using System.Collections.Generic;
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.Redis.Repositories;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.ToolRepository.Entities;
using Siger.Middlelayer.ToolRepository.Response;

namespace Siger.Middlelayer.ToolRepository.Repositories.Interface
{
    public interface ISigerProjectToolblxRepository: IApiToolRepositoryBase<SigerProjectToolBlx>
    {
        List<ToolStudyList> GetToolStudyList(int sectionID,string programNo,int projectID,int page,int pagesize, out int totalCount);
        List<ToolUnStudyList> GetToolUnStudyList(int sectionID,string programNo, int projectID, int page, int pagesize, out int totalCount);
        List<OutLineUnStudyList> GetOutLineUnStudyList(int sectionID,string programNo, int projectID, int page, int pagesize, out int totalCount);
        void EnvelopingLineStudy(string RService, ProgramListRepository repository, int uerID,int companyId, int projectId,int machineId,int spindle_id,int blxID,long startTime,long endTime, string programNo,int desc);
        void EnvelopingLineUnStudy(string RService, ProgramListRepository repository, int userId, int companyId, int projectId,int machineId, int spindle_id, long starttime, long endtime, string programno,int desc);
        void EnvelopingOutlineStudy(string RService, ProgramListRepository repository, int userId, int companyId, int projectId, int blx_id, 
            long starttime, long endtime, int machineId, int spindleName, int cutterLocationName, string programno, ToolMarkType cutter_type,int num,int desc,string remarks="");
        void EnvelopingOutlineUnStudy(string RService, ProgramListRepository repository, int userId, int companyId, int projectId, int spindle_id, 
            int cutter_location_id, long starttime, long endtime, int machineId, int spindleName, int cutterLocationName, string programno, ToolMarkType cutter_type,int count,int desc,string remarks="");
        List<OutLineStudyList> GetOutLineStudyList(int sectionID,string programNo, int projectID, int page, int pagesize, out int totalCount);
        IEnumerable<ResponseToolConfig> GetResponseToolConfigs(int sectionID, string programNo, int projectID, int page, int pagesize, out int totalCount);

    }
}