using System.Collections.Generic;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Share.Models;
using Siger.Middlelayer.ToolRepository.Entities;
using Siger.Middlelayer.ToolRepository.Response;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.Middlelayer.ToolRepository.Repositories.Interface
{
    public interface ISigerToolChangeRecordRepository: IApiToolRepositoryBase<siger_tool_change_record>
    {
        /// <summary>
        /// ȡ߸ҳб
        /// </summary>
        /// <param name="sectionId"></param>
        /// <param name="projectId"></param>
        /// <param name="toolName"></param>
        /// <param name="toolDrawno"></param>
        /// <param name="reason"></param>
        /// <param name="userName"></param>
        /// <param name="page"></param>
        /// <param name="pageSize"></param>
        /// <returns></returns>
        IPagedCollectionResult<ToolChangeRecord> GetToolChangeRecord(int sectionId, int projectId, string toolName, string toolDrawno, string reason, string userName, int page, int pageSize);

        IEnumerable<ToolChangeRecord> ExportToolChangeRecords(int sectionId, int projectId, string toolName,
            string toolDrawno, string reason, string userName);

        List<ChangeToolInfo> GetToolLifeReport(int sectionid, int projectId, long startTime, long endTime, string toolToolType, int toolId);

        /// <summary>
        /// ȡԱб
        /// </summary>
        /// <param name="projectId"></param>
        /// <returns></returns>
        List<ResponseChangeUserList> GetChangeToolUser(int projectId);

        List<MachineData> GetMachineList(int sectionId, int projectId);

        ToolChangeImportResult ImportToolChange(IEnumerable<ToolChangeList> tooChanges, int projectId);
    }
}