using System.Collections.Generic;
using System.Linq;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.ToolRepository.Entities;
using Siger.Middlelayer.ToolRepository.Repositories.Interface;

namespace Siger.Middlelayer.ToolRepository.Repositories
{
    internal class SigerProjectToolEmailConfigRepository : ApiToolRepositoryBase<SigerProjectToolEmailConfig>,
        ISigerProjectToolEmailConfigRepository
    {
        ApiToolDbContext dbContext;
        public SigerProjectToolEmailConfigRepository(ApiToolDbContext context) : base(context)
        {
            dbContext = context;
        }

        public IPagedCollectionResult<SettingEmailUser> GetSettingEmailList( int projectId, int page, int pageSize=10)
        {
            var data = dbContext.siger_project_user.Where(f => f.status == (int)RowState.Valid && f.projectid == projectId && !string.IsNullOrEmpty(f.work_email));
            var query = from suser in data
                        join email in dbContext.siger_project_tool_email_config on suser.mid equals email.mid
                        
                        select new SettingEmailUser
                        {
                            id=email.mid,
                            Name = suser.name,
                            Host=email.first_host,
                            FromEmail = email.first_email,
                            Password=email.first_password,
                            ToEmail = suser.work_email,
                            Workcode =suser.work_code
                        };

           var totalCount = query.Count();

            var entities = query.OrderBy(o => o.id).Skip((page - 1) * pageSize).Take(pageSize).ToList();

            return new PagedCollectionResult<SettingEmailUser>(entities, totalCount);
        }

        public IEnumerable<ResponseSettingEmailUser> GetSettingEmailUsers(int projectId)
        {
           // var query=from u in dbContext.siger_project_user
                   //   join e in dbContext.siger_tool_send_message_type on

            var data = dbContext.siger_project_user.Where(f => f.status == (int)RowState.Valid && f.projectid == projectId && !string.IsNullOrEmpty(f.work_email));
            var query = from suser in data
                        join email in dbContext.siger_project_tool_email_config on suser.mid equals email.mid into temp
                        from mails in temp.DefaultIfEmpty()
                        
                        select new ResponseSettingEmailUser {
                             Name=suser.name,
                             Mid=suser.mid,
                             Email=suser.work_email,
                             IsSet= mails==null?0:1
                        };

            return query.ToList().Distinct();
        }

        public siger_project_user GetUser(int projectId,int mid)
        {
            var query = from u in dbContext.siger_project_user
                        where u.projectid == projectId && u.mid == mid && !string.IsNullOrEmpty(u.work_email)
                        select u;
        
            return query.ToList().FirstOrDefault();
           
        }
    }
}