﻿using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;

namespace Siger.Middlelayer.ToolRepository.Request
{
    public class RequestCalibration
    {
        [Required(ErrorMessage = "machineId required")]
        public int machineId { get; set; }
        [Required(ErrorMessage = "spindleName required")]
        public string spindleName { get; set; }
        [Required(ErrorMessage = "toolNo required")]
        public string toolNo { get; set; }
        [Required(ErrorMessage = "programNo required")]
        public string programNo { get; set; }

        public List<CalibrationItem> items { get; set; }
    }
    public class CalibrationItem
    {
        public int picIndex { get; set; }
        public int id { get; set; }
        public string name { get; set; }
        public string beginTime { get; set; }
        public string endTime { get; set; }
    }
}
