﻿using System.Runtime.Serialization;

namespace Siger.Middlelayer.ToolRepository.Request
{
    public class RequestComputeBlx
    {
        public int companyID { get; set; }
        public int projectID { get; set; }
        public int spindleID { get; set; }
        public int machineID { get; set; }
        public long ccStart { get; set; }
        public long ccEnd { get; set; }
        public string programNum { get; set; }
    }

    public class RequestComputeBlxWithCutterType: RequestComputeBlx
    {
        public int toolNum { get; set; }
        public int side { get; set; }
        public string label { get; set; }
        public int ccNum { get; set; }
    }
    /// <summary>
    /// 刀具标定 重置数据
    /// </summary>
    public class RequestComputeBlxBd
    {
        public int companyID { get; set; }
        public int projectID { get; set; }
        public int spindleID { get; set; }
        public int machineID { get; set; }
        public int toolNum { get; set; }
        public string programNum { get; set; }

    }

    [DataContract]
    public class RequestGetProcessCountLoadInfoHistory
    {
        [DataMember]
        public int companyID { get; set; }

        [DataMember]
        public int projectID { get; set; }

        [DataMember]
        public string spindleID { get; set; }

        [DataMember]
        public int machineID { get; set; }

        [DataMember]
        public long startTime { get; set; }

        [DataMember]
        public long endTime { get; set; }

        [DataMember]
        public string programNum { get; set; }

        [DataMember]
        public string toolNum { get; set; }
    }
}
