﻿using System.Collections.Generic;
using Siger.Middlelayer.Common.ModuleEnum;

namespace Siger.Middlelayer.ToolRepository.Response
{
    public class ResponseToolsDashbord
    {
        public AlarmCount alarmCount { get; set; }
        public Dictionary<int, List<DashBordToolsNode>> data { get; set; }
    }

    public class DashBordToolsNode
    {
        public string pn { get; set; }
        public string spn { get; set; }
        public int Dispaylevel { get; set; }
        public string machine_name { get; set; }
        public string machine_id { get; set; }
        public string spindle_name { get; set; }
        public string cutter_location_name { get; set; }
        public string is_open { get; set; }
        public string toolname { get; set; }
        public string drawingcode { get; set; }
        public string supplierimg { get; set; }
        public int alarm_grade { get; set; }
        public string section_list { get; set; }
        public string spindle_id { get; set; }
        public string cutter_location_id { get; set; }
        public int? ratelife { get; set; }
        public int? surplus_life { get; set; }
        public string bk_color { get; set; }
        public string font_color { get; set; }
        public AlarmGrade searchType { get; set; }
        public string Programs { get; set; }
    }

    public class AlarmCount
    {
        /// <summary>
        /// 质量
        /// </summary>
        public int quality { get; set; }
        /// <summary>
        /// 正常
        /// </summary>
        public int normal { get; set; }
        /// <summary>
        /// 寿命
        /// </summary>
        public int life { get; set; }
        /// <summary>
        /// 磨损
        /// </summary>
        public int alarm { get; set; }
        /// <summary>
        /// 崩刃
        /// </summary>
        public int tipping { get; set; }
        /// <summary>
        /// 断刀
        /// </summary>
        public int cutter_broke { get; set; }
        public int close { get; set; }
    }
}
