﻿using System.Collections.Generic;
using Siger.Middlelayer.Repository.Data.Tpm;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Repository.Response;
using Siger.Middlelayer.TpmRepository.Entities;
using Siger.Middlelayer.TpmRepository.Response;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.Middlelayer.TpmRepository.Repositories.Interface
{
    public interface IPlanRepository : ITpmRepositoryBase<siger_project_plan>
    {
        IPagedCollectionResult<GetListSearchPlan> GetPagedlistsSearchPlan(IEnumerable<int> machineIds, int modeType, int value_type, int severity_level, int instruction_cycle
            , int datetype, int department, int person, int gt, int lt, int status, int projectId, int page, int pagesize,int state,int creator=0);

        CommonImportResult ImportLevelPlanList(IEnumerable<LevelPlanTemplate> types, int projectId, int userId, int levelCount);

        IEnumerable<GetListSearchPlan> GetlistsSearchPlan(IEnumerable<int> machineIds, int modeType, int value_type, int severity_level, int instruction_cycle
            , int datetype, int department, int person, int gt, int lt, int projectId);

        /// <summary>
        /// 兼容被禁用的已执行记录
        /// </summary>
        /// <param name="machineIds"></param>
        /// <param name="modeType"></param>
        /// <param name="startTime"></param>
        /// <param name="endTime"></param>
        /// <param name="severity_level"></param>
        /// <param name="projectId"></param>
        /// <param name="page"></param>
        /// <param name="pagesize"></param>
        /// <param name="toexcel"></param>
        /// <returns></returns>
        IPagedCollectionResult<GetListSearchPlan> GetlistPlanResultItem(IEnumerable<int> machineIds, int modeType, int startTime, int endTime, int severity_level, int projectId, int page, int pagesize, int toexcel);

        IEnumerable<GetPlanResult> GetlistPlanOneResultItem(int plantimeid, int starttime, int endtime, int projectId);

        IEnumerable<PlanAppItemList> GetListAppIndexItem(IEnumerable<int> machineIds, int information, int todayTime, int projectId);

        bool InsertPlanSign(siger_project_plan_sign planSign);

        IEnumerable<siger_project_plan_sign> GetTodayPlanSigns(int machineId, int userId, int projectId);

        IEnumerable<siger_project_plan_sign> GetPlanSigns(int userId, int projectId);

        IEnumerable<ResponsePlanTime> GetPlanCostTime(int projectid, int start, int end);

        CommonImportResult ImportLevelPlanListSkf(IEnumerable<LevelPlanListSkf> types, int projectId, int userId, int levelCount);

        List<string> GetMachineNames(int machineId, int projectId);

        List<ResponseIdTitle> GetMachineNames(IEnumerable<int> machineIds, int projectId);

        IEnumerable<AllPlan> GetAllPlans(int projectId, int start, int end);

        string GetMachineParentName(int machineId, int projectId);
    }
}
