﻿
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.TpmRepository.Entities;
using Siger.Middlelayer.TpmRepository.Repositories;
using Siger.Middlelayer.TpmRepository.Response;
using Siger.Middlelayer.Utility.ImportEntities;
using System.Collections.Generic;

namespace Siger.Middlelayer.TpmRepository.Repositories.Interface
{
    /// <summary>
	/// ISigerAndonExpectionTypeRepository
	/// </summary>
    public interface ISigerAndonExpectionTypeRepository : ITpmRepositoryBase<siger_andon_expection_type>
    {
        IPagedCollectionResult<ResponseAndonExpection> GetData(string name, int ProjectId, int page, int pagesize);
        List<ResponseAndonExpection> GetTreeData(string name, int ProjectId);
        List<int> GetAllExpectionlevel(int id, int projectid);
        CommonImportResult ImportAndonExpection(IEnumerable<ImportAndonExpection> types, int projectId);
        List<siger_andon_expection_type> GetExpectionSonSelfLevel(int parent, int projectid);
    }
}
