﻿using System.Collections.Generic;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.TpmRepository.Entities;

namespace Siger.Middlelayer.TpmRepository.Repositories.Interface
{
    public interface ITpmRepositoryBase<TEntity> : IRepositoryBase<TEntity> where TEntity : TpmEntityBase
    {
        IEnumerable<siger_project_level_section> GetParentSelfLevelSections(int parentid, int projectid);

        siger_project_level_section GetLevelSectionByMachineId(int machineId, int projectId);

        siger_project_level_section GetTopLevelSection(int projectId);

        IEnumerable<siger_project_repair_add_user> GetAddUserListByRepairId(int repairId);

        IEnumerable<siger_project_machine_fault> GetMachineFaultByFaultId(int faultId, int projectId);

        siger_app_mute GetAppMuteByRepairId(int repairId, int projectId, int userId);

        siger_project_section GetSectionByUserId(int userId);

        IEnumerable<siger_project_user> GetUserBySectionType(int projectId, int type);

        IEnumerable<siger_project_level_section> GetParentLevelSections(int id, int projectid);

        IEnumerable<siger_project_level_section> GetSonLevelSections(int parentId, int projectid);

        IEnumerable<int> ListAllMidArrBySectionIDArr(IEnumerable<int> sectionIds, int time);

        string GetUserOpenId(int mid, int projectId);

        int GetProjectLanguage(int projectId);

        siger_project_user GetUserByMid(int mid);

        IEnumerable<int> GetUserIdsByDepartment(int department, int projectId);

        IEnumerable<siger_andon_expection_type> GetExpectionSonLevel(int parent, int projectid);
        IEnumerable<siger_andon_expection_type> GetExpectionParent(int id, int projectid);
        IEnumerable<siger_andon_expection_type> GetExpectionParent(int id, int projectid, List<siger_andon_expection_type> list);
    }
}
