﻿using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Siger.Middlelayer.WmsRepository.Entities
{
    /// <summary>
    /// 库存变更详情
    /// </summary>
    public class siger_wms_stock_detail : WmsEntityBase
    {
        public siger_wms_stock_detail(string stockNo, int userid, string username,int pid)
        {
            this.stockNo = stockNo;
            this.userid = userid;
            this.username = username;
            updatetime = DateTime.Now;
            state = 1;
            projectid = pid;
        }
        public siger_wms_stock_detail()
        {

        }
        public string inventorySN { get; set; }

        [Key]
        public int id { get; set; }
        public int type { get; set; }
        public string billID { get; set; }
        public int inventory { get; set; }
        public string inventoryName { get; set; }
        public string inventorySpec { get; set; }
        public int allqty { get; set; }

        public int qty { get; set; }
        public string batch { get; set; }
        public string no { get; set; }
        public int userid { get; set; }
        public string username { get; set; }
        public DateTime updatetime { get; set; }
        public int locationid { get; set; }
        public string locationname { get; set; }

        public DateTime productingtime { get; set; }
        public int fromsourcebatch { get; set; }
        public int state { get; set; }
        public int projectid { get; set; }

        public int businessid { get; set; }
        public string businessName { get; set; }
        public string stockNo { get; set; }
        [NotMapped]
        public string serialNumber
        {
            get
            {
                if (string.IsNullOrEmpty(no))
                {
                    return batch;
                }
                else
                {
                    return no;
                }
            }
        }
    }
}
