using System;
using System.Linq;
using System.Linq.Expressions;
using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.WmsRepository.Entities;
using Siger.Middlelayer.WmsRepository.Repositories.Interface;
using Siger.Middlelayer.WmsRepository.Response;

namespace Siger.Middlelayer.WmsRepository.Repositories
{
    internal class siger_wms_stock_alarmRepository : WMSRepositoryBase<siger_wms_stock_alarm>, Isiger_wms_stock_alarmRepository
    {
        private readonly ApiWmsDbContext dbContext;
        public siger_wms_stock_alarmRepository(ApiWmsDbContext context) : base(context)
        {
            dbContext = context;
        }

        public IPagedCollectionResult<ResponseStockAlarm> GetPagedList(int material_id, int projectid, int page, int pagesize)
        {
            var query = dbContext.siger_wms_stock_alarm.Where(t => t.projectid == projectid && t.status != (int)RowState.Invalid);
            var queryList = from q in query
                            join m in dbContext.siger_tr_materials on q.material_id equals m.id
                            join u1 in dbContext.siger_user on q.creator equals u1.id
                            join u2 in dbContext.siger_user on q.operate_mid equals u2.id into uu
                            from u2 in uu.DefaultIfEmpty()
                            select new ResponseStockAlarm
                            {
                                id = q.id,
                                material_id = q.material_id,
                                material_pn = q.material_pn,
                                material_name = m.name,
                                operate_mid = u2.nickname,
                                operate_time = UnixTimeHelper.ConvertIntDateTime(q.operate_time),
                                information_type = q.information_type,
                                create_time = UnixTimeHelper.ConvertIntDateTime(q.create_time),
                                creator = u1.nickname,
                                status = q.status,
                                trigger_time = UnixTimeHelper.ConvertIntDateTime(q.trigger_time),
                                quantity = q.stock_quantity
                            };
            Expression<Func<ResponseStockAlarm, bool>> materialExpression = q => true;
            if(material_id > 0)
            {
                materialExpression = q => q.material_id == material_id;
            }

            var totalCount = queryList.Count(materialExpression);
            if (page != 0)
            {
                var entities = queryList.Where(materialExpression).Skip((page - 1) * pagesize).Take(pagesize).AsNoTracking().ToList();
                return new PagedCollectionResult<ResponseStockAlarm>(entities, totalCount);
            }
            else
            {
                var entities = queryList.Where(materialExpression).AsNoTracking().ToList();
                return new PagedCollectionResult<ResponseStockAlarm>(entities, totalCount);
            }
        }
    }
}

