using System.Collections.Generic;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.WmsRepository.Entities;
using Siger.Middlelayer.WmsRepository.Repositories.Interface;

namespace Siger.Middlelayer.WmsRepository.Repositories
{
   internal class siger_wms_storage_typeRepository: WMSRepositoryBase<siger_wms_storage_type>,Isiger_wms_storage_typeRepository
    {
       private readonly ApiWmsDbContext dbContext;
        public siger_wms_storage_typeRepository(ApiWmsDbContext context) : base(context)
        {
            dbContext = context;
        }
        public IEnumerable<LevelSectionTree> GetWavehouseTypeTree(int ProjectId)
        {
            var list = new List<LevelSectionTree>();
            var query = GetList(f=>f.status==(int)RowState.Valid && f.projectid == ProjectId);

            foreach (var type in query)
            {
                list.Add(new LevelSectionTree { id = type.id, name = type.name, pid = type.parentid, open = true });
            }

            return list;
        }
    }
}

