﻿using System;
using System.Collections.Generic;
using System.Linq;
using Dapper;
using Siger.Middlelayer.Dapper.ResultData;
using Siger.Middlelayer.Dapper.SearchCondition;

namespace Siger.Middlelayer.Dapper
{
    public class ExceptionParamsSateRepository: DapperRepositoryBase
    {
        public ExceptionParamsSateRepository(int companyId, int projectId) : base(companyId, projectId)
        {
        }

        public IEnumerable<CncExceptionParamsSate> GetCncExceptionParamsSates(IEnumerable<int> machinIds)
        {
            if (!machinIds.Any())
            {
                return new List<CncExceptionParamsSate>();
            }
            var machineIds = string.Join(",", machinIds);
            var search = $" AND TotalSecond >0 AND MachineId in ({machineIds})";

            using (var conn = GetDbConnection())
            {
                var noClosedSql = $@"SELECT MachineId,Spindle,StartTime,Type,`Values`,Uplimit,Downlimit,TotalSecond,EndTime FROM {CncExceptionParamsSate} 
                                    WHERE Closed = 0 {search} ORDER BY MachineID";
                return conn.Query<CncExceptionParamsSate>(noClosedSql);
            }
        }

        public KeyValuePair<Pagination, IList<CncExceptionParamsSate>> GetPagedCncExceptionParamsSates(Pagination pagin, ExceptionParamCondition condition)
        {
            var search = "WHERE 1=1 AND TotalSecond > 0 ";
            if (condition.BigSmallSpan >= 0)
            {
                var second = condition.BigSmallSpan;
                if (condition.BigSmall == 1)
                {
                    //search += $" AND TotalSecond > {second}";
                    search += $" AND unix_timestamp(StartTime)+{second} < unix_timestamp(EndTime)";
                }
                if (condition.BigSmall == 2)
                {
                    //search += $" AND TotalSecond < {second}";
                    search += $" AND unix_timestamp(StartTime)+{second} > unix_timestamp(EndTime)";
                }
            }

            if (condition.StartTime != null && condition.EndTime != null)
            {
                search += $" AND StartTime >= '{condition.StartTime}' AND EndTime <= '{condition.EndTime}'";
            }

            if (condition.MachinIds.Any())
            {
                var machineIds = string.Join(",", condition.MachinIds);
                search += $" AND MachineId in ({machineIds})";
            }

            if (condition.ErrType > 0)
            {
                search += $" AND Type = {condition.ErrType}";
            }

            var offset = (pagin.CurrentPageIndex - 1) * pagin.PageSize;
            using (var conn = GetDbConnection())
            {
                var executeQuery = $@"SELECT id, MachineId,Spindle,StartTime,Type,`Values`,Uplimit,Downlimit,TotalSecond,EndTime FROM {CncExceptionParamsSate}
                                        {search} ORDER BY StartTime DESC LIMIT {offset},{pagin.PageSize}";

                var executeCount = $"SELECT COUNT(*) AS CountNum FROM {CncExceptionParamsSate} {search}";
                
                var listScore = conn.Query<CncExceptionParamsSate>(executeQuery).ToList();
                pagin.TotalItemCount = conn.Query<int>(executeCount).SingleOrDefault();
                var result = new KeyValuePair<Pagination, IList<CncExceptionParamsSate>>(pagin, listScore);
                return result;
            }
        }

        public IList<CncExceptionParamsSate> GetNoPagedCncExceptionParamsSates(ExceptionParamCondition condition)
        {
            var search = "WHERE 1=1 AND TotalSecond > 0";
            if (condition.StartTime != null && condition.EndTime != null)
            {
                search += $" AND StartTime >= '{condition.StartTime}' AND EndTime <= '{condition.EndTime}'";
            }

            if (condition.MachinIds.Any())
            {
                var machineIds = string.Join(",", condition.MachinIds);
                search += $" AND MachineId in ({machineIds})";
            }

            if (condition.ErrType > 0)
            {
                search += $" AND Type = {condition.ErrType}";
            }

            using (var conn = GetDbConnection())
            {
                var executeQuery = $@"SELECT id, MachineId,Spindle,StartTime,Type,`Values`,Uplimit,Downlimit,TotalSecond,EndTime FROM {CncExceptionParamsSate}
                                        {search} ORDER BY StartTime DESC";

                return conn.Query<CncExceptionParamsSate>(executeQuery).ToList();
            }
        }

        public override void Dispose()
        {
            throw new NotImplementedException();
        }
    }
}
