﻿using Dapper;
using Siger.Middlelayer.Dapper.Data;
using Siger.Middlelayer.Log;
using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.Middlelayer.Dapper.FlowMetek
{
    public class InspectionDtRepostiory : RepositoryBase
    {
        public InspectionDtRepostiory() : base()
        {
        }
        /// <summary>
        /// 电路板检测
        /// </summary>
        /// <returns></returns>
        public IEnumerable<MeteDatil> GetMeteCircuits(string CreateDate)
        {
            using (var con = GetDbConnection2())
            {
                var sql = $"select * from CircuitBoardData";
                var condtion = string.Empty;
                if (!string.IsNullOrEmpty(CreateDate))
                {
                    sql += $" WHERE CreateTime>='{CreateDate}'";
                }
                sql += " ORDER BY CreateTime  ASC;";
                Logger.WriteLineInfo("CircuitBoardData is  start"+sql);
                return con.Query<MeteDatil>(sql);

            }
        }

        /// <summary>
        /// 表头电量检测
        /// </summary>
        /// <returns></returns>
        public IEnumerable<MeteHeadDetail> GetHeadTrace(string CreateDate)
        {
            using(var col=GetDbConnection2())
            {
                var sql = $"select * from MeterHeadData";
                var condtion = string.Empty;
                if (!string.IsNullOrEmpty(CreateDate))
                {
                    sql += $" WHERE CreateTime>='{CreateDate}'";
                }
                sql += " ORDER BY CreateTime  ASC;";
                Logger.WriteLineInfo("MeterHeadData is  start"+sql);
                return col.Query<MeteHeadDetail>(sql);
            }
        }

        /// <summary>
        /// 皮膜表检测
        /// </summary>
        /// <returns></returns>
        public IEnumerable<MeteSum> GetMeteSums(string CreateDate)
        {
            using(var coy=GetDbConnection2())
            {
                var sql = $"SELECT TOP 320 * from InspectionDetial";
                var condtion = string.Empty;
                if (!string.IsNullOrEmpty(CreateDate))
                {
                    sql += $" WHERE Createtime>='{CreateDate}'";
                }
                sql += " ORDER BY Createtime  ASC;";
                Logger.WriteLineInfo("InspectionDetial is  start"+sql);
                return coy.Query<MeteSum>(sql);
            }
        }
        public override void Dispose()
        {
            throw new NotImplementedException();
        }
    }
}
