﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Dapper;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Dapper.ResultData;
using Siger.Middlelayer.Common.Log;
namespace Siger.Middlelayer.Dapper
{
    public class LocationAlarmRepository : DapperRepositoryBase
    {
        public LocationAlarmRepository(int companyId, int projectId) : base(companyId, projectId)
        {
        }

        public bool InsertLocationAlarm(LocationAlarm model)
        {
            var ret = false;
            var sql = string.Empty;
            sql = $"INSERT INTO `{LocationAlarmTb}`( `sectionID`, `machine`, `type`, `exception`, `parameter`, `rule`, `abnormal_time`, `trigger`, `status`, `start_time`, `end_time`, `workOrderId`, `pid`) " +
                                                           $"VALUES ( '{model.sectionID}', '{model.machine}','{model.type}', '{model.exception}', '{model.parameter}', '{model.rule}', '{model.abnormal_time}', '{model.trigger}', '{model.status}', '{model.start_time.ToString(UnixTimeHelper.DateTimeFormat)}', '{model.end_time.ToString(UnixTimeHelper.DateTimeFormat)}', '{model.workOrderId}', '{model.pid}');";
            Logger.WriteLineError($"InsertLocationAlarm sql:{sql}");
            try
            {
                using (var connetion = GetDbConnection())
                {

                    var result = connetion.Execute(sql);
                    if (result > 0)
                    {
                        ret = true;
                    }
                }
            }
            catch (Exception ex)
            {
                Logger.WriteLineError($"InsertLocationAlarm failed" + ex.Message);
            }
            return ret;
        }

        public bool UpdateLocationAlarmByOrder(LocationAlarm model)
        {
            var ret = false;
            try
            {
                using (var connetion = GetDbConnection())
                {
                    var sql = $"UPDATE `{LocationAlarmTb}` SET `sectionID` = '{model.sectionID}', `machine` = '{model.machine}', `type` = '{model.type}', `trigger` = '{model.trigger}', `status` = '{model.status}', `start_time` = '{model.start_time.ToString(UnixTimeHelper.DateTimeFormat)}', `end_time` = '{model.end_time.ToString(UnixTimeHelper.DateTimeFormat)}', `workOrderId` = '{model.workOrderId}', `pid` = '{model.pid}' WHERE `workOrderId` = '{model.workOrderId}';";
                    var result = connetion.Execute(sql);
                    if (result > 0)
                    {
                        ret = true;
                    }
                }
            }
            catch (Exception ex)
            {
                Logger.WriteLineError(ex.Message);
            }
            return ret;
        }

        public bool UpdateLocationAlarmById(LocationAlarm model)
        {
            var ret = false;
            try
            {
                using (var connetion = GetDbConnection())
                {
                    var sql = $"UPDATE `{LocationAlarmTb}` SET `sectionID` = '{model.sectionID}', `machine` = '{model.machine}', `type` = '{model.type}', `trigger` = '{model.trigger}', `status` = '{model.status}', `start_time` = '{model.start_time.ToString(UnixTimeHelper.DateTimeFormat)}', `end_time` = '{model.end_time.ToString(UnixTimeHelper.DateTimeFormat)}', `workOrderId` = '{model.workOrderId}', `pid` = '{model.pid}' WHERE `id` = '{model.id}';";
                    var result = connetion.Execute(sql);
                    if (result > 0)
                    {
                        ret = true;
                    }
                }
            }
            catch (Exception ex)
            {
                Logger.WriteLineError(ex.Message);
            }
            return ret;
        }

        public List<LocationAlarm> GetAbnormalData(int pid)
        {
            try
            {
                using (var connetion = GetDbConnection())
                {
                    var sql = $"SELECT * from {LocationAlarmTb} WHERE `trigger`=0 AND `workOrderId`='' AND `pid`='{pid}';";
                    var result = connetion.Query<LocationAlarm>(sql);
                    return result.ToList();
                }
            }
            catch (Exception ex)
            {
                Logger.WriteLineError(ex.Message);
                return new List<LocationAlarm>();
            }
        }
        public List<LocationAlarm> GetAbnormalDataByOrder(int pid, string work_order)
        {
            try
            {
                using (var connetion = GetDbConnection())
                {
                    var sql = $"SELECT * from {LocationAlarmTb} WHERE `workOrderId`='{work_order}' AND `pid`='{pid}';";
                    var result = connetion.Query<LocationAlarm>(sql);
                    return result.ToList();
                }
            }
            catch (Exception ex)
            {
                Logger.WriteLineError(ex.Message);
                return new List<LocationAlarm>();
            }
        }
        public bool DeleteLocationAlarm(int id)
        {
            var ret = false;
            try
            {
                using (var connetion = GetDbConnection())
                {
                    var sql = $"DELETE FROM siger_location_alarm WHERE id = '{id}';";
                    var result = connetion.Execute(sql);
                    if (result > 0)
                    {
                        ret = true;
                    }
                }
            }
            catch (Exception ex)
            {
                Logger.WriteLineError(ex.Message);
            }
            return ret;
        }
        public override void Dispose()
        {
            throw new NotImplementedException();
        }
    }
}
