﻿using System;
using MySql.Data.MySqlClient;
using Siger.Middlelayer.Common.Configuration;
using Siger.Middlelayer.Common.Log;

namespace Siger.Middlelayer.Dapper
{
    public class SigerMysqlMonitor
    {
        public static void CheckRunning()
        {
            var dbConnection = ConfigManager.GetValue("DbSetting", "DbConnection", string.Empty);
            if (!string.IsNullOrEmpty(dbConnection))
            {
                MySqlConnection connect = null;
                try
                {
                    connect = new MySqlConnection(dbConnection);
                    connect.Open();
                    Logger.WriteLineInfo("monitor: mysql service is running.");
                }
                catch (Exception e)
                {
                    Logger.WriteLineError($"monitor: connect mysql db failed, error:" + e);
                }
                finally
                {
                    connect?.Close();
                    connect?.Dispose();
                }
            }
        }
    }
}
