﻿using System;
using System.Collections.Generic;
using Dapper;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Log;
using Siger.Middlelayer.Dapper.ResultData;

namespace Siger.Middlelayer.Dapper
{
    public class ToolPragramListRepository : DapperRepositoryBase
    {
        public ToolPragramListRepository(int companyId, int projectId) : base(companyId, projectId)
        {
        }

        public IEnumerable<ToolProgramList> GetRunningPrograms(DateTime sdate)
        {
            var start = sdate.ToString(ParameterConstant.DateTimeFormat);

            var search = "WHERE 1=1";
            search += $" AND ChangeTime >= '{start}' ";

            try
            {
                using (var conn = GetDbConnection())
                {
                    var executeQuery = $@"SELECT id, mn as MachineId,pn as ProgramNo,spn as SubProgramNo,spindle as SpindleName,tn as ToolName,ChangeTime FROM {TMS_ProgramList}
                                        {search} ORDER BY ChangeTime";

                    return conn.Query<ToolProgramList>(executeQuery);
                }
            }
            catch
            {
                throw;
            }
        }

        public override void Dispose()
        {
            throw new NotImplementedException();
        }
    }
}
