﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.Middlelayer.Redis.Repositories
{
    public class KmLampConfigRepository : RedisRepositoryBase
    {
        public KmLampConfigRepository(int companyId, int projectId) : base(companyId, projectId)
        {
        }

        public string GetIpAddress(int machineId)
        {
            try
            {
                var data = Client.HGet(HashKMLampConfig, machineId.ToString());
                if (!string.IsNullOrEmpty(data))
                {
                    return data;
                }
            }
            catch
            {
                throw;
            }
            finally
            {
                Dispose();
            }
            return null;
        }

        public void Dispose()
        {
            Client?.Dispose();
        }
    }
}
