﻿using System;
using System.Collections.Generic;
using System.Linq;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Common.Log;
using Siger.Middlelayer.Redis.RedisEntities;

namespace Siger.Middlelayer.Redis.Repositories
{
    public class QMSDefaultInfoConfigRepository : RedisRepositoryBase
    {
        private readonly bool _dispose;
        public QMSDefaultInfoConfigRepository(int companyId, int projectId, bool dispose = true) : base(companyId, projectId)
        {
            _dispose = dispose;
        }

        public bool SetItemInfoConfig(string key, QMSDefaultInfoConfig config)
        {
            try
            {
                return Client.HSet(QMSDefaultInfoConfig, key, JsonHelper.SerializerToJsonString(config));
            }
            catch(Exception ex)
            {
                Logger.WriteLineError(ex.ToString());
                return false;
            }
            finally
            {
                if (_dispose)
                {
                    Dispose();
                }
            }
        }

        public Dictionary<string, QMSDefaultInfoConfig> GetAllCofigs()
        {
            try
            {
                var list = Client.HGetAll<QMSDefaultInfoConfig>(QMSDefaultInfoConfig);
                if (list.Any())
                {
                    return list;
                }
                return new Dictionary<string, QMSDefaultInfoConfig>();
            }
            catch
            {
                return new Dictionary<string, QMSDefaultInfoConfig>();
            }
            finally
            {
                if (_dispose)
                {
                    Dispose();
                }
            }
        }

        public QMSDefaultInfoConfig GetConfigByMachineId(int machineid)
        {
            try
            {
                var list = Client.HGetAll<QMSDefaultInfoConfig>(QMSDefaultInfoConfig);
                if (list.Values.Any())
                {
                    var model = list.Values.FirstOrDefault(t => t.machineID == machineid);
                    return model;
                }
                return null;
            }
            catch
            {
                return null;
            }
            finally
            {
                if (_dispose)
                {
                    Dispose();
                }
            }
        }

        public QMSDefaultInfoConfig GetSingleByKey(string key)
        {
            try
            {
                return Client.HGet<QMSDefaultInfoConfig>(QMSDefaultInfoConfig, key);
            }
            catch
            {
                return null;
            }
            finally
            {
                if (_dispose)
                {
                    Dispose();
                }
            }
        }

        public bool DeleteConfig(string key)
        {
            try
            {
                return Client.HDel(QMSDefaultInfoConfig, key) > 0;
            }
            catch
            {
                return false;
            }
            finally
            {
                if (_dispose)
                {
                    Dispose();
                }
            }
        }

        public void Dispose()
        {
            Client?.Dispose();
        }
    }
}
