﻿using Microsoft.Extensions.Logging;
using Siger.DataSchedule.Infrastructure.Extend;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.AppMessagePush;
using Siger.Middlelayer.Common.AppMessagePush.Model;
using Siger.Middlelayer.Common.AppSMSSend;
using Siger.Middlelayer.Common.AppSMSSend.Model;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Log;
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.Redis;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.TpmRepository;
using Siger.Middlelayer.TpmRepository.Entities;
using Siger.Middlelayer.TpmRepository.Response;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading;
using System.IO;
using Newtonsoft.Json.Linq;
using Newtonsoft.Json;
using System.Timers;

namespace Siger.Schedule.TpmModule
{
    public class AutoSyncTpm : IScheduleJob
    {
        AutoSyncTpmHelper tpmHelper;
        public void PreInit(ScheduleContext context)
        {
            Logger.RegisterLogEngine(Module.Tpm);
            tpmHelper = new AutoSyncTpmHelper();
        }

        public void Execute(ScheduleContext context)
        {
            tpmHelper.StartTask();
        }

        public void AfterExecute(ScheduleContext context)
        {
            
        }

    
        public void Undo()
        {
            
        }
    }

    public class AutoSyncTpmHelper : IDisposable
    {
        private static AutoSyncTpmHelper _helper;
        public static AutoSyncTpmHelper Instance = _helper ?? (_helper = new AutoSyncTpmHelper());

        private static ApiTpmDbContext _context;
        public AutoSyncTpmHelper()
        {
            _context = new ApiTpmDbContext();
        }

        public void StartTask()
        {
            try
            {
                var thread = new Thread(Process)
                {
                    IsBackground = true
                };
                thread.Start();
            }
            catch (Exception e)
            {
                Logger.WriteLineError("AutoSyncTpm failed, error:" + e);
            }
        }

        private void Process()
        {
            while (true)
            {
                Execute();
                Thread.Sleep(1000 * 60 * 1); // 1分钟
            }
        }

        private void Execute()
        {
            try
            {
                if (RedisCache.Client == null)
                {
                    RedisCache.Connect();
                }
            }
            catch (Exception e)
            {
                Logger.WriteLineInfo($"Redis connect error:" + e);
            }
            var dbConfigs = RedisCache.Instance.GetDbNameConfigs();
            if (dbConfigs.Any())
            {
                _context = new ApiTpmDbContext();
                foreach (var dbNameConfig in dbConfigs)
                {
                    if (string.IsNullOrWhiteSpace(dbNameConfig.RedisDbName))
                    {
                        Logger.WriteLineError($"AutoSyncTpm DbNameConfig setting error, can not find redisdbname by cid:{dbNameConfig.Cid}, pid:{dbNameConfig.Pid}.");
                        continue;
                    }
                    ExcuteRepairReportPushMessage(dbNameConfig.Pid);
                }
                Dispose();
            }
        }

        public void ExcuteRepairReportPushMessage(int projectId)
        {
            try
            {
                var time = UnixTimeHelper.GetNow();
                RepairReportPlan(time, projectId);
            }
            catch (Exception e)
            {
                Logger.WriteLineError("AutoSyncTpm Execute RepairReport Timing Task failed" + e);
            }
        }

        #region 每分钟执行一次 异常上报工单通知

        private void RepairReportPlan(int time, int _projectId)
        {
            var configRepeatTime = GetConfigRepeatTime();
            var repairTemps = GetRepairReportPlans(time, configRepeatTime, _projectId);
            if (repairTemps.Any())
            {
                var config = GetAppProjectConfig(_projectId);
                if (config != null)
                {
                    var levelSections = GetSonLevelSections(0, _projectId);
                    var pushmessage = new MessagePushHelper(config.appkey, config.appsecret, config.signid,
                        config.issendSMS);
                    repairTemps = repairTemps.GroupBy(t => t.repairid).Select(t => t.FirstOrDefault()).ToList();
                    var isTranslate = GetProjectLanguage(_projectId) == (int)LanguageType.EN;
                    var translateHelper = new TranslateHelper(isTranslate);
                    var pushTitle = translateHelper.GetTranslateText(TranslateEnEnum.AbnormalReport);
                    foreach (var repairTemp in repairTemps)
                    {
                        var repairInfo = _context.siger_project_repair.FirstOrDefault(t =>
                            t.id == repairTemp.repairid && t.status > 0 && t.status < 6 && t.projectid == _projectId);
                        if (repairInfo != null)
                        {
                            if (repairTemp.push_status == 0)
                            {
                                //记录log
                                //信息记录
                                repairInfo.report_level = repairTemp.level;
                                _context.siger_project_repair.Update(repairInfo);
                                var repairListInfo = new siger_project_repair_list
                                {
                                    repairid = repairInfo.id,
                                    status = repairInfo.status,
                                    projectid = _projectId,
                                    mid = 0,
                                    title = ((int)RepairListStatus.AbnormalReport).ToString()
                                };
                                var reportMidList = new List<int>();
                                var sectionMidList = new List<int>();
                                var midList = GetReportPushAndSectionMidList(repairInfo, repairTemp.machineid, time, _projectId, repairTemp.machinelevel);
                                reportMidList.AddRange(midList[(int)AppPushType.PushAndSave]);
                                sectionMidList = midList[(int)AppPushType.SaveNotPush];
                                var groupMidList = sectionMidList.Where(t => reportMidList.Contains(t)).ToList();
                                var grouptitle = GetUserGroupTitleByMid(groupMidList).ToList();
                                grouptitle = grouptitle.Distinct().ToList();
                                var paras = new Dictionary<string, string>();
                                if (grouptitle.Any())
                                {
                                    repairListInfo.content =
                                        "【" + GetPositionByMachineId(repairInfo.machineid, _projectId, levelSections) + "】 " +
                                        (repairTemp.spacetime) +
                                        translateHelper.GetTranslateText(TranslateEnEnum.NoResponseMinuteFeedbackUp) +
                                        string.Join(",", grouptitle) + " " +
                                        translateHelper.GetTranslateText(TranslateEnEnum.EnteredWorkOrder);
                                    paras.Add("time", repairTemp.spacetime + "");
                                    paras.Add("userGroupTitle", string.Join(",", grouptitle));
                                    paras.Add("enter", string.Join(",", translateHelper.GetTranslateText(TranslateEnEnum.EnteredWorkOrder)));
                                }
                                else
                                {
                                    repairListInfo.content =
                                        "【" + GetPositionByMachineId(repairInfo.machineid, _projectId, levelSections) + "】 " +
                                        (repairTemp.spacetime) +
                                        translateHelper.GetTranslateText(TranslateEnEnum.NoResponseMinuteFeedbackUp);
                                    paras.Add("time", repairTemp.spacetime + "");
                                    paras.Add("userGroupTitle", string.Join(",", grouptitle));
                                    paras.Add("enter", "");
                                }
                                repairListInfo.creattime = time;
                                _context.siger_project_repair_list.Add(repairListInfo);
                                if (_context.SaveChanges() > 0)
                                {
                                    foreach (var mid in sectionMidList)
                                    {
                                        if (mid > 0)
                                        {
                                            var repairMsg = new siger_app_project_message
                                            {
                                                repairid = repairTemp.repairid,
                                                projectid = _projectId,
                                                type = (int)RepairOrPlanStatus.Repair,
                                                title = pushTitle,
                                                status = repairTemp.status,
                                                create_time = UnixTimeHelper.GetNow(),
                                                content = repairListInfo.content,
                                                tomid = mid
                                            };
                                            _context.siger_app_project_message.Add(repairMsg);
                                            _context.SaveChanges();

                                            if (reportMidList.Contains(mid))
                                            {
                                                var mute = _context.siger_app_mute.FirstOrDefault(t =>
                                                        t.projectid == _projectId && t.status == 0 &&
                                                        (t.repairid == repairInfo.id || t.repairid == 0) && t.mid == mid);
                                                if (mute == null)
                                                {
                                                    try
                                                    {
                                                        var isOnline = IsOnlie(repairMsg.tomid, repairMsg.projectid,
                                                            SystemConfigKey.AppUserOnlineInterval);
                                                        var toUserKey = GetUserAppKey(repairMsg.tomid,
                                                            repairMsg.projectid);
                                                        var mobile = GetUserMobile(repairMsg.tomid,
                                                            repairMsg.projectid);
                                                        int templateId = SMSTemplateConst.RepairReportPlan;
                                                        if (isTranslate)
                                                        {
                                                            templateId = TemplateHelper.GetSmsEnTemplateId(templateId);
                                                        }
                                                        if (templateId > 0)
                                                        {
                                                            pushmessage.PushMessage(repairMsg, isOnline, toUserKey, mobile, templateId, paras);
                                                            SendWeXinMessage(repairMsg.title, repairMsg.content, time,
                                                                repairMsg.tomid, _projectId, TemplateHelper.GetWxTempleteId(isTranslate));
                                                        }
                                                    }
                                                    catch (Exception ex)
                                                    {
                                                        Logger.WriteLineError("push message error :" + ex);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }

                            if (repairTemp.push_status == 1)
                            {
                                repairInfo.report_level = repairTemp.level;
                                _context.siger_project_repair.Update(repairInfo);
                                if (_context.SaveChanges() > 0)
                                {
                                    var message = _context.siger_app_project_message.FirstOrDefault(t =>
                                        t.projectid == _projectId && t.repairid == repairInfo.id
                                                                  && t.status == repairTemp.status &&
                                                                  t.type == (int)RepairOrPlanStatus.Repair);
                                    if (message != null)
                                    {
                                        var mute = _context.siger_app_mute.FirstOrDefault(t =>
                                            t.projectid == _projectId && t.status == 0 &&
                                            (t.repairid == repairInfo.id || t.repairid == 0) && t.mid == message.tomid);
                                        if (mute != null)
                                        {
                                            var isOnline = IsOnlie(message.tomid, message.projectid,
                                                SystemConfigKey.AppUserOnlineInterval);
                                            var toUserKey = GetUserAppKey(message.tomid, message.projectid);
                                            var mobile = GetUserMobile(message.tomid, message.projectid);
                                            int templateId = SMSTemplateConst.WaitingForOrders;
                                            if (isTranslate)
                                            {
                                                templateId = TemplateHelper.GetSmsEnTemplateId(templateId);
                                            }
                                            if (templateId > 0)
                                            {
                                                var location = GetPositionByMachineId(repairInfo.machineid, _projectId, levelSections);
                                                var fault = _context.siger_project_machine_fault.FirstOrDefault(t =>
                                                    t.id == repairInfo.faultid);
                                                var paras = new Dictionary<string, string>
                                                {
                                                    {"location", location},
                                                    {"fault", fault?.title ?? "-" + translateHelper.GetTranslateText(TranslateEnEnum.Other) + "-"}
                                                };
                                                pushmessage.PushMessage(message, isOnline, toUserKey, mobile,
                                                    templateId, paras);
                                                SendWeXinMessage(message.title, message.content, time,
                                                    message.tomid, _projectId, TemplateHelper.GetWxTempleteId(isTranslate));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        private IEnumerable<string> GetUserGroupTitleByMid(IEnumerable<int> midList)
        {
            var query = from q in _context.siger_project_user
                        join p in _context.siger_project_usergroup
                            on q.usergroupid.ToInt() equals p.id
                        where q.status == (int)RowState.Valid && p.status == (int)RowState.Valid
                                                               && midList.Contains(q.mid)
                        select p.title;
            return query;
        }

        private List<RepairTemp> GetRepairReportPlans(int time, int configRepeatTime, int _projectId)
        {
            var tempList = new List<RepairTemp>();
            var repairs = GetRepairMachineList(_projectId).ToList();
            if (repairs.Any())
            {
                foreach (var repair in repairs)
                {
                    var machine = _context.siger_project_machine.FirstOrDefault(t => t.id == repair.machineid);
                    var spaceTimeArr = machine != null
                        ? GetRepairSpaceTime(_projectId, machine.machinelevel > 0 ? machine.machinelevel : 1)
                        : new List<siger_project_repair_report>();
                    if (spaceTimeArr.Any())
                    {
                        var temp = new RepairTemp
                        {
                            repairid = repair.id,
                            machineid = repair.machineid,
                            report_level = repair.report_level,
                            status = repair.status,
                            spacetime = 0,
                            machinelevel = machine.machinelevel > 0 ? machine.machinelevel : 1
                        };
                        switch (repair.status)
                        {
                            case 1:
                                var difference = time - repair.createtime;
                                temp = GetCompareRepairTempList(temp, difference, configRepeatTime, 1, spaceTimeArr);
                                if (temp.level > 0)
                                {
                                    tempList.Add(temp);
                                }
                                break;
                            case 2:
                                difference = time - repair.taketime;
                                temp = GetCompareRepairTempList(temp, difference, configRepeatTime, 2, spaceTimeArr);
                                if (temp.level > 0)
                                {
                                    tempList.Add(temp);
                                }
                                break;
                            case 3:
                                difference = time - repair.signtime;
                                temp = GetCompareRepairTempList(temp, difference, configRepeatTime, 3, spaceTimeArr);
                                if (temp.level > 0)
                                {
                                    tempList.Add(temp);
                                }
                                break;
                            case 4:
                                difference = time - repair.completetime;
                                temp = GetCompareRepairTempList(temp, difference, configRepeatTime, 4, spaceTimeArr);
                                if (temp.level > 0)
                                {
                                    tempList.Add(temp);
                                }
                                break;
                        }
                    }
                }
            }
            return tempList;
        }

        private IEnumerable<siger_project_repair> GetRepairMachineList(int projectId)
        {
            var query = from q in _context.siger_project_repair
                        where q.projectid == projectId && q.status > 0 && q.status < 6 && q.work_type == 1
                        select q;

            return query;
        }

        private RepairTemp GetCompareRepairTempList(RepairTemp temp, int difference, int configRepeatTime,
            int type, List<siger_project_repair_report> spaceTimeArr)
        {
            temp.type = type;
            temp.push_status = 0;
            temp.level = 0;
            var spaceTime1 = spaceTimeArr.FirstOrDefault(t => t.type == type && t.start_level == 1);
            if (spaceTime1 != null)
            {
                var spacetime = spaceTime1.space_time * 60;
                if (difference % (configRepeatTime * 60) < 60 && difference < spacetime && difference >= configRepeatTime * 60)
                {
                    temp.level = 1;
                    temp.push_status = 1;//循环推送
                    temp.spacetime = spaceTime1.space_time;
                    temp.difference = difference / 60;
                }
            }
            var spaceTime2 = spaceTimeArr.FirstOrDefault(t => t.type == type && t.start_level == 2);
            var spaceTime3 = spaceTimeArr.FirstOrDefault(t => t.type == type && t.start_level == 3);
            if (spaceTime3 != null && spaceTime1 != null && spaceTime2 != null)
            {
                var spacetime3 = spaceTime3.space_time * 60 + spaceTime2.space_time * 60 + spaceTime1.space_time * 60;
                var spacetime2 = spaceTime2.space_time * 60 + spaceTime1.space_time * 60;
                var spacetime1 = spaceTime1.space_time * 60;
                var diff3 = difference - spacetime3;
                var diff2 = difference - spacetime2;
                var diff1 = difference - spacetime1;
                if (diff3 >= 0 && difference % spacetime3 < 60 && diff3 < 120)
                {
                    temp.level = 4;
                    temp.difference = difference / 60;
                    temp.spacetime = spaceTime3.space_time;
                }
                else if (diff3 >= 0 && diff3 % (configRepeatTime * 60) < 60 && diff3 >= configRepeatTime * 60)
                {
                    temp.level = 4;
                    temp.difference = difference / 60;
                    temp.spacetime = spaceTime3.space_time;
                }
                else if (diff2 >= 0 && diff3 < 0 && difference % spacetime2 < 60 && diff2 < 120)
                {
                    temp.level = 3;
                    temp.difference = difference / 60;
                    temp.spacetime = spaceTime2.space_time;
                }
                else if (diff2 >= 0 && diff3 < 0 && diff2 % (configRepeatTime * 60) < 60 && diff2 >= configRepeatTime * 60)
                {
                    temp.level = 3;
                    temp.difference = difference / 60;
                    temp.spacetime = spaceTime2.space_time;
                }
                else if (diff1 >= 0 && diff2 < 0 && difference % spacetime1 < 60 && diff1 < 120)
                {
                    temp.level = 2;
                    temp.difference = difference / 60;
                    temp.spacetime = spaceTime1.space_time;
                }
                else if (diff1 >= 0 && diff2 < 0 && diff1 % (configRepeatTime * 60) < 60 && diff1 >= configRepeatTime * 60)
                {
                    temp.level = 2;
                    temp.difference = difference / 60;
                    temp.spacetime = spaceTime1.space_time;
                }
            }
            return temp;
        }

        #endregion

        #region 获取配置数据

        private siger_app_project_config GetAppProjectConfig(int projectId)
        {
            return _context.siger_app_project_config.FirstOrDefault(q =>
                q.projectId == projectId && q.status == (int)RowState.Valid);
        }

        private int GetConfigRepeatTime()
        {
            var config = _context.siger_system_config.FirstOrDefault(q =>
                q.key == SystemConfigKey.MessageRepeatTime && q.status == (int)RowState.Valid);
            return (config != null ? config.value : "15").ToInt();
        }

        private List<siger_project_repair_report> GetRepairSpaceTime(int projectId, int machinelevel)
        {
            var spaceTimesList = _context.siger_project_repair_report
                .Where(t => t.projectid == projectId && t.status == (int)RowState.Valid &&
                            t.machinelevel == machinelevel).ToList();
            return spaceTimesList;
        }

        private int GetProjectLanguage(int projectId)
        {
            var languageType = _context.siger_project.FirstOrDefault(t => t.id == projectId);
            return languageType?.language ?? 0;
        }

        #endregion

        #region 获取消息通知配置数据，发送消息

        private void SendWeXinMessage(string title, string content, int time, int tomid, int projectid, string templeteId)
        {
            if (tomid == 0)
            {
                return;
            }

            var date = UnixTimeHelper.ConvertIntDateTime(time);

            var openid = GetUserOpenId(tomid, projectid);
            if (string.IsNullOrEmpty(openid))
            {
                return;
            }

            MessageBean msgcont = new MessageBean();

            ContBean prmBean = new ContBean
            {
                value = title,
                color = "#173177"
            };

            msgcont.firstPrm = prmBean;

            List<ContBean> datas = new List<ContBean>();
            prmBean = new ContBean
            {
                value = date,
                color = "#173177"
            };
            datas.Add(prmBean);

            prmBean = new ContBean
            {
                value = content,
                color = "#173177"
            };
            datas.Add(prmBean);

            msgcont.keywordsPrm = datas;

            prmBean = new ContBean
            {
                value = "",
                color = "#173177"
            };
            msgcont.remarkPrm = prmBean;

            WeChatPushHelper.sendMsg(openid, templeteId, msgcont);
        }

        private bool IsOnlie(int mid, int projectId, string key)
        {
            var intervalMinutes = 5;
            var config =
                _context.siger_system_config.FirstOrDefault(q => q.key == key && q.status == (int)RowState.Valid);
            if (config != null)
            {
                var interval = config.value.ToInt();
                if (interval > 0)
                {
                    intervalMinutes = interval;
                }
            }

            var entity = _context.siger_app_project_user.FirstOrDefault(q =>
                q.projectId == projectId && q.mid == mid && q.status == (int)RowState.Valid);
            if (entity != null)
            {
                if (entity.refresh_time != null)
                {
                    if (DateTime.Now.Subtract(entity.refresh_time.Value).TotalMinutes <= intervalMinutes)
                    {
                        return true;
                    }
                }

                return false;
            }

            return false;
        }

        private string GetUserAppKey(int mid, int projectId)
        {
            var entity = _context.siger_app_project_user.FirstOrDefault(q =>
                q.projectId == projectId && q.mid == mid && q.status == (int)RowState.Valid);
            if (entity != null)
            {
                return entity.appkey;
            }

            return string.Empty;
        }

        private string GetUserMobile(int mid, int projectId)
        {
            var entity = _context.siger_project_user.FirstOrDefault(q =>
                q.projectid == projectId && q.mid == mid && q.status == (int)RowState.Valid);
            if (entity != null)
            {
                return entity.mobile;
            }

            return string.Empty;
        }

        private string GetUserOpenId(int mid, int projectId)
        {
            var entity = _context.siger_app_project_user.FirstOrDefault(q =>
                q.projectId == projectId && q.mid == mid && q.status == (int)RowState.Valid);
            if (entity != null)
            {
                return entity.openid;
            }

            return string.Empty;
        }

        #endregion

        #region 获取推送列表

        private Dictionary<int, List<int>> GetReportPushAndSectionMidList(siger_project_repair repairInfo, int machineId, int time, int _projectId, int machinelevel)
        {
            var res = new Dictionary<int, List<int>>();
            var reportLevelMidList =
                GetReportLevelMidList(repairInfo, time, _projectId, machinelevel)
                    .Where(t => t > 0).Distinct().ToList();
            var workgroupUsermidList = GetWorkgroupUsermidList(repairInfo, machineId, time, _projectId).Where(t => t > 0).Distinct().ToList();
            res.Add((int)AppPushType.PushAndSave, reportLevelMidList);
            res.Add((int)AppPushType.SaveNotPush, workgroupUsermidList);
            return res;
        }

        private List<int> GetWorkgroupUsermidList(siger_project_repair repairInfo, int machineid, int time, int projectId)
        {
            var midList = new List<int>
            {
                repairInfo.mid,
                repairInfo.takemid,
                repairInfo.signmid,
                repairInfo.completemid,
                repairInfo.checkmid
            };
            var repairadd = _context.siger_project_repair_add_user.Where(t => t.repairid == repairInfo.id && t.status == (int)RowState.Valid).ToList();
            if (repairadd.Any())
            {
                midList.AddRange(repairadd.Select(t => t.mid).ToList());
            }

            var date = DateTime.Parse(UnixTimeHelper.ConvertIntDate(time));
            //var userMids = _context.siger_project_working_machine_set.Where(q => q.machine_id == machineid && q.project_id == projectId && q.status == (int)RowState.Valid).Select(q => q.user_mid)
            //    .Distinct().ToList();
            var machineRelation = _context.siger_project_working_relation_machine.FirstOrDefault(f => f.machine == machineid && f.projectid == projectId);
            if (machineRelation == null)
                return midList;
            var userMids = machineRelation.employsSplit;
            var cals = _context.siger_project_working_calendar.Where(q => userMids.Contains(q.user_mid) && q.status == (int)RowState.Valid
                                                                                     && q.working_group == machineRelation.workgroup_id && q.date == date).ToList();
            if (cals.Any())
            {
                var shiftids = cals.Select(m => m.shift_id).Distinct().ToList();
                var shifts = _context.siger_project_shift.Where(q => shiftids.Contains(q.id) && q.status == (int)RowState.Valid);
                var nowDate = UnixTimeHelper.GetUnixByDate(date.ToShortDateString());
                foreach (var calendar in cals)
                {
                    var shift = shifts.FirstOrDefault(q => q.id == calendar.shift_id);
                    if (shift == null)
                    {
                        continue;
                    }

                    //零点到零点的，全部都算
                    if (shift.start_time == 0 && shift.end_time == 0)
                    {
                        midList.Add(calendar.user_mid);
                    }
                    //在时间范围内的
                    else if (nowDate + shift.start_time <= time && nowDate + shift.end_time >= time)
                    {
                        midList.Add(calendar.user_mid);
                    }
                    //结束时间小于开始时间
                    else if (shift.end_time <= shift.start_time)
                    {
                        if (nowDate + shift.start_time <= time && nowDate + 86400 + shift.end_time >= time)
                        {
                            midList.Add(calendar.user_mid);
                        }
                    }
                }
            }

            return midList.ToList();
        }

        private List<int> GetReportLevelMidList(siger_project_repair repairInfo, int time, int _projectId, int machinelevel)
        {
            var midList = new List<int>();
            if (repairInfo.report_level > 0)
            {
                midList = ListLevelUser(_projectId, repairInfo.report_level, machinelevel).ToList();
                return midList;
            }

            var spaceTimesList = _context.siger_project_repair_report
                .Where(t => t.projectid == _projectId && t.status == (int)RowState.Valid && t.machinelevel == machinelevel).ToList();
            //获取上报等级
            var templevel = GetRepairReportLevel(repairInfo, time, spaceTimesList);
            if (templevel > 0)
            {
                midList = ListLevelUser(_projectId, templevel, machinelevel).ToList();
            }
            return midList;
        }

        private IEnumerable<int> ListLevelUser(int projectId, int level, int machinelevel)
        {
            var query = from l in _context.siger_project_repair_report_level
                        join u in _context.siger_project_user on l.usergroup_id.ToString() equals u.usergroupid
                        where l.project_id == projectId && l.level == level && l.status == (int)RowState.Valid
                              && l.usergroup_id > 0 && l.machinelevel == machinelevel
                        select u;
            var mids = new List<int>();
            if (query.ToList().Any())
            {
                mids = query.ToList().Select(t => t.mid).ToList();
            }
            return mids;
        }

        #endregion

        #region 获取异常上报等级

        private int GetRepairReportLevel(siger_project_repair repair, int time, List<siger_project_repair_report> spaceTimeArr)
        {
            int templevel = 0;
            if (repair != null)
            {
                if (spaceTimeArr.Any())
                {
                    var spaceTime4 = spaceTimeArr.FirstOrDefault(t => t.type == 1 && t.start_level == 3);
                    var spaceTime3 = spaceTimeArr.FirstOrDefault(t => t.type == 1 && t.start_level == 2);
                    var spaceTime2 = spaceTimeArr.FirstOrDefault(t => t.type == 1 && t.start_level == 1);
                    switch (repair.status)
                    {
                        case 1:
                            var difference = time - repair.createtime;
                            templevel = GetCompareTempLevel(difference, spaceTime4, spaceTime3, spaceTime2);
                            break;
                        case 2:
                            var difference1 = time - repair.createtime;
                            var difference2 = repair.taketime - repair.createtime;
                            difference = Math.Max(difference1, difference2);
                            templevel = GetCompareTempLevel(difference, spaceTime4, spaceTime3, spaceTime2);
                            break;
                        case 3:
                            difference1 = time - repair.createtime;
                            difference2 = repair.taketime - repair.createtime;
                            var difference3 = repair.signtime - repair.createtime;
                            difference = Math.Max(difference1, difference2);
                            difference = Math.Max(difference3, difference);
                            templevel = GetCompareTempLevel(difference, spaceTime4, spaceTime3, spaceTime2);
                            break;
                        case 4:
                            difference1 = time - repair.createtime;
                            difference2 = repair.taketime - repair.createtime;
                            difference3 = repair.signtime - repair.createtime;
                            var difference4 = repair.completetime - repair.createtime;
                            difference = Math.Max(difference1, difference2);
                            difference = Math.Max(difference3, difference);
                            difference = Math.Max(difference4, difference);
                            templevel = GetCompareTempLevel(difference, spaceTime4, spaceTime3, spaceTime2);
                            break;
                        case 5:
                            difference1 = time - repair.createtime;
                            difference2 = repair.taketime - repair.createtime;
                            difference3 = repair.signtime - repair.createtime;
                            difference4 = repair.completetime - repair.createtime;
                            var difference5 = repair.checktime - repair.createtime;
                            difference = Math.Max(difference1, difference2);
                            difference = Math.Max(difference3, difference);
                            difference = Math.Max(difference4, difference);
                            difference = Math.Max(difference5, difference);
                            templevel = GetCompareTempLevel(difference, spaceTime4, spaceTime3, spaceTime2);
                            break;
                    }
                }
            }

            return templevel;
        }

        private int GetCompareTempLevel(int difference, siger_project_repair_report spaceTime4,
            siger_project_repair_report spaceTime3, siger_project_repair_report spaceTime2)
        {
            int templevel;
            if (spaceTime4 != null && difference > spaceTime4.space_time)
            {
                templevel = 4;
            }
            else if (spaceTime3 != null && difference > spaceTime3.space_time)
            {
                templevel = 3;
            }
            else if (spaceTime2 != null && difference > spaceTime2.space_time)
            {
                templevel = 2;
            }
            else
            {
                //此时该工单未超时
                templevel = 1;
            }

            return templevel;
        }

        #endregion

        #region 产线层级

        private siger_project_machine_attribution GetLevelMachineByMachineId(int machineId)
        {
            return _context.siger_project_machine_attribution.FirstOrDefault(t => t.machine == machineId && t.attribution == 1 && t.status == (int)RowState.Valid);
        }

        private IEnumerable<siger_project_level_section> GetSonLevelSections(int parentId, int projectid)
        {
            var query = from c in _context.siger_project_level_section
                        where c.parentid == parentId && c.projectid == projectid && c.status == (int)RowState.Valid
                        select c;

            return query.ToList().Concat(query.ToList().SelectMany(t => GetSonLevelSections(t.id, projectid)));
        }

        public string GetPositionByMachineId(int machineId, int _projectId, IEnumerable<siger_project_level_section> levelSections)
        {
            var names = new List<string>();
            //工位信息
            var attibution = _context.siger_project_machine_attribution.FirstOrDefault(q => q.machine == machineId && q.projectid == _projectId &&
                                                                                            q.status == (int)RowState.Valid);
            if (attibution == null)
            {
                return string.Empty;
            }

            var level = _context.siger_project_level_section.FirstOrDefault(q => q.id == attibution.station && q.projectid == _projectId && q.status == (int)RowState.Valid);
            if (level != null)
            {
                names.Add(level.title);
                var machine = _context.siger_project_machine.FirstOrDefault(q => q.id == machineId);
                if (machine != null)
                {
                    names.Add(machine.title);
                }
            }
            return string.Join("-", names);
        }

        public IEnumerable<siger_project_level_section> GetParentLevelSections(int id, int projectid, IEnumerable<siger_project_level_section> levelSections)
        {
            var query = from c in levelSections
                        where c.id == id && c.status == (int)RowState.Valid
                        select c;

            return query.ToList().Concat(query.ToList().SelectMany(t => GetParentLevelSections(t.parentid, projectid, levelSections)));
        }

        #endregion

        public void Dispose()
        {
            _context?.Dispose();
        }
    }

    static class TemplateHelper
    {
        public static int GetSmsEnTemplateId(int SmsTempleteId)
        {
            int templeteId = 0;
            switch (SmsTempleteId)
            {
                case SMSTemplateConst.WaitingForOrders:
                    templeteId = SMSTemplateConst.WaitingForOrders_en;
                    break;
                case SMSTemplateConst.WaitingForCheckIn:
                    templeteId = SMSTemplateConst.WaitingForCheckIn_en;
                    break;
                case SMSTemplateConst.WaitingForRepair:
                    templeteId = SMSTemplateConst.WaitingForRepair_en;
                    break;
                case SMSTemplateConst.WaitingForRenew:
                    templeteId = SMSTemplateConst.WaitingForRenew_en;
                    break;
                case SMSTemplateConst.WaitingForFeedback:
                    templeteId = SMSTemplateConst.WaitingForFeedback_en;
                    break;
                case SMSTemplateConst.Completed:
                    templeteId = SMSTemplateConst.Completed_en;
                    break;
                case SMSTemplateConst.Deleted:
                    templeteId = SMSTemplateConst.Deleted_en;
                    break;
                case SMSTemplateConst.CooperateRepair:
                    templeteId = SMSTemplateConst.CooperateRepair_en;
                    break;
                case SMSTemplateConst.RenewFail:
                    templeteId = SMSTemplateConst.RenewFail_en;
                    break;
                case SMSTemplateConst.RepairReportPlan:
                    templeteId = SMSTemplateConst.RepairReportPlan_en;
                    break;
                case SMSTemplateConst.PlanReportPlan:
                    templeteId = SMSTemplateConst.PlanReportPlan_en;
                    break;
                case SMSTemplateConst.PlanTaskPlan:
                    templeteId = SMSTemplateConst.PlanTaskPlan_en;
                    break;
                case SMSTemplateConst.AndonPlan:
                    templeteId = SMSTemplateConst.AndonPlan_en;
                    break;
                case SMSTemplateConst.SparepartPrepareTemplate:
                    templeteId = SMSTemplateConst.SparepartPrepareTemplate_cn;
                    break;
            }

            return templeteId;
        }

        public static string GetWxTempleteId(bool isTranslate)
        {
            if (isTranslate)
            {
                return WeChatPushHelper.temleteIdMdp;
            }

            return WeChatPushHelper.temleteIdMdp;
        }
    }

    static class WeChatPushHelper
    {
        private static string APPID = "wx81faa5428f25deb3";

        private static string SECRET = "e7f24125ddcfe6cec9d674d29d3844a5";

        private static string wxtokenssf;

        private static int expiresIn;


        //{{first.DATA}}
        //处理时间：{{keyword1.DATA}}
        //处理结果：{{keyword2.DATA}}
        //{{remark.DATA}}
        //
        //您好，有新的消息通知。
        //处理时间：2019-01-02 11:08
        //处理结果：您的《物业报修申请》已经受理，维修人员将在您的预约时间段（2019-01-03 10:00——11:00）上门维修。
        //感谢您的使用。
        public static string temleteIdMdp = "mdpOK5hrFh_36XoSap06IAeDBsykrBhRo3bhV7T_Woo";

        //{{first.DATA}}
        //计划：{{keyword1.DATA}}
        //关联联系人：{{keyword2.DATA}}
        //计划时间：{{keyword3.DATA}}
        //{{remark.DATA}}
        //
        //您好，根据日历安排，您有以下计划
        //计划：每客笔记的第二笔款项到期，需要沟通回款事宜
        //关联联系人：Pony
        //计划时间：2015-09-09
        //请您及时处理！
        public static string temleteIdS11 = "S11lGmOqHcv3ogeT1L7AG5x_20q4WenIF7gH_AYppH4";


        //{{first.DATA}}
        //异常行为：{{keyword1.DATA}}
        //发生时间：{{keyword2.DATA}}
        //{{remark.DATA}}
        //
        //尊敬的用户，您在本店消费时存在如下违规异常行为
        //异常行为：在禁烟区吸烟
        //发生时间：2017-04-03 13
        //请及时终止违规行为，谢谢合作！
        public static string temleteIdYjf = "YjfMKxQalx8Xo0dSmqqyEVbByNmZQcPyb-XAuHiom6I";

        //{{first.DATA}}
        //设备位置：{{keyword1.DATA}}
        //异常说明：{{keyword2.DATA}}
        //报修时间：{{keyword3.DATA}}
        //{{remark.DATA}}
        //
        //注意，维修工单异常
        //设备位置： 加工四厂-DL 16线-OP30 粗车
        //异常说明：未按时接单
        //报修时间：2018-01-12 15:23
        //请协调资源处理 ~
        public static string temleteIdMls = "mls0Xe_xjvNuxGej7Whx2R0YG2oeJKZjd94-4DjQq2w";

        //{{first.DATA}}
        //工单号：{{keyword1.DATA}}
        //维修设备：{{keyword2.DATA}}
        //维修人：{{keyword3.DATA}}
        //完工时间：{{keyword4.DATA}}
        //{{remark.DATA}}
        //
        //工单已维修完成，请及时验收。
        //工单号：RO20180202170101
        //维修设备：打印机
        //维修人：User
        //完工时间：2018-02-02
        //来自CoolCare设备监测平台
        public static string temleteIdJuj = "JuJS3382VRHf_cS_DyeHs9OsQZqva5FrVNkTmS3R_-Q";

        //{{first.DATA}}
        //工单单号：{{keyword1.DATA}}
        //工单标题：{{keyword2.DATA}}
        //时间：{{keyword3.DATA}}
        //{{remark.DATA}}
        //
        //您的申请已经受理
        //工单单号：CB20170425001
        //工单标题：电脑硬盘坏死
        //时间：2017-04-25
        //您的申请我们已经收到，会尽快处理，请耐心等待！
        public static string temleteIdTbx = "tbxISjWSYVtjzmCwAIy3E4moUtXh3tze6xRbaWxLvLY";


        //{{first.DATA}}
        //工单单号：{{keyword1.DATA}}
        //工单内容：{{keyword2.DATA}}
        //提交时间：{{keyword3.DATA}}
        //{{remark.DATA}}
        //
        //您提交的诉求已经受理
        //工单单号：1234567890
        //工单内容：电脑卡顿。
        //提交时间：2018-12-18 21:39:40
        //您可以点击查看工单受理状态
        public static string temleteIdOiw = "oiWp1XKsqAbCLma-KvIhYfdFC1nk8MLNnfRcTS7yho0";


        //{{first.DATA}}
        //工单编号：{{keyword1.DATA}}
        //工单标题：{{keyword2.DATA}}
        //工单状态：{{keyword3.DATA}}
        //工单处理人：{{keyword4.DATA}}
        //{{remark.DATA}}
        //
        //亲，您的工单有最新进展
        //工单编号：SD000223
        //工单标题：关于陈勇明(ym-chen6)[现场修复桌面软件]的服务请求申请
        //工单状态：已接单
        //工单处理人：冯工程师
        //我们将向您提供100分的服务，请继续等待。
        public static string temleteIdHdj = "Hdjldcro7HDHsIZaYaK733z05r-XvLXME46TmmvDoIM";


        //{{first.DATA}}
        //位置：{{keyword1.DATA}}
        //设备：{{keyword2.DATA}}
        //故障类型：{{keyword3.DATA}}
        //故障内容：{{keyword4.DATA}}
        //工单创建时间：{{keyword5.DATA}}
        //{{remark.DATA}}
        //
        //op30-半精车床出现故障，请前往处理
        //位置：加工四厂-D/C 16L
        //设备：op30-半精车
        //故障类型：机械故障
        //故障内容：自动门卡死
        //工单创建时间：2017-11-17 13:12:32
        //推荐解决方案：检查机械结构
        public static string temleteIdZkg = "ZKG3kFsncwcJyc3xeDz5qGpfCtH__D45nM7z0XDAhdc";

        static WeChatPushHelper()
        {
            try
            {
                string serviceAddress = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + APPID + "&secret=" + SECRET;
                HttpWebRequest request = (HttpWebRequest)WebRequest.Create(serviceAddress);
                request.Method = "GET";
                request.ContentType = "application/json;charset=UTF-8";
                HttpWebResponse response = (HttpWebResponse)request.GetResponse();
                Stream myResponseStream = response.GetResponseStream();
                StreamReader myStreamReader = new StreamReader(myResponseStream, Encoding.UTF8);
                string retString = myStreamReader.ReadToEnd();
                myStreamReader.Close();
                myResponseStream.Close();
                //解析josn
                JObject jso = (JObject)JsonConvert.DeserializeObject(retString);
                wxtokenssf = jso["access_token"] != null ? jso["access_token"].ToString() : "";
                expiresIn = jso["expires_in"] != null ? int.Parse(jso["expires_in"].ToString()) : 0;
                //Console.WriteLine("----------get wxtoken success-----------");
            }
            catch (Exception ex)
            {
                Logger.WriteLineError("----------get wxtoken failed:" + ex.Message + "-----------");
            }

            if (expiresIn > 0)
            {
                System.Timers.Timer timer = new System.Timers.Timer
                {
                    Enabled = true,
                    Interval = expiresIn * 1000 - 15 * 60 * 1000
                };
                // 提前15分钟刷新token
                //执行间隔时间,单位为毫秒; 这里实际间隔为10分钟  
                timer.Start();
                timer.Elapsed += new ElapsedEventHandler(getToken);
            }
        }

        private static void getToken(object source, ElapsedEventArgs e)
        {
            try
            {
                string serviceAddress = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + APPID + "&secret=" + SECRET;
                HttpWebRequest request = (HttpWebRequest)WebRequest.Create(serviceAddress);
                request.Method = "GET";
                request.ContentType = "application/json;charset=UTF-8";
                HttpWebResponse response = (HttpWebResponse)request.GetResponse();
                Stream myResponseStream = response.GetResponseStream();
                StreamReader myStreamReader = new StreamReader(myResponseStream, Encoding.UTF8);
                string retString = myStreamReader.ReadToEnd();
                myStreamReader.Close();
                myResponseStream.Close();
                //解析josn
                JObject jso = (JObject)JsonConvert.DeserializeObject(retString);
                wxtokenssf = jso["access_token"] != null ? jso["access_token"].ToString() : "";
                expiresIn = jso["expires_in"] != null ? int.Parse(jso["expires_in"].ToString()) : 0;
                //Console.WriteLine("----------update wxtoken success-----------");
            }
            catch (Exception ex)
            {
                Logger.WriteLineError("----------update wxtoken failed: " + ex.Message + "-----------");
            }

        }

        public static void testttt()
        {
            Console.WriteLine("I am in testttt!");
        }

        public static void sendMsg(string openId, string templeteId, MessageBean msgPrm)
        {
            try
            {
                if (string.IsNullOrEmpty(wxtokenssf))
                {
                    string serviceTokenAddress = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + APPID + "&secret=" + SECRET;
                    HttpWebRequest tokenRequest = (HttpWebRequest)WebRequest.Create(serviceTokenAddress);
                    tokenRequest.Method = "GET";
                    tokenRequest.ContentType = "application/json;charset=UTF-8";
                    HttpWebResponse tokenResponse = (HttpWebResponse)tokenRequest.GetResponse();
                    Stream myTokenResponseStream = tokenResponse.GetResponseStream();
                    StreamReader myTokenStreamReader = new StreamReader(myTokenResponseStream, Encoding.UTF8);
                    string retString1 = myTokenStreamReader.ReadToEnd();
                    myTokenStreamReader.Close();
                    myTokenResponseStream.Close();
                    //解析josn
                    JObject jso1 = (JObject)JsonConvert.DeserializeObject(retString1);
                    wxtokenssf = jso1["access_token"] != null ? jso1["access_token"].ToString() : "";
                }
                string serviceAddress = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=" + wxtokenssf;
                HttpWebRequest request = (HttpWebRequest)WebRequest.Create(serviceAddress);
                request.Method = "POST";
                request.ContentType = "application/json";

                StringBuilder sb = new StringBuilder();
                sb.Append("{");
                sb.Append(@"""touser"":""");
                sb.Append(openId);
                sb.Append(@""",");
                sb.Append(@"""template_id"":""");
                sb.Append(templeteId);
                sb.Append(@""",");
                sb.Append(@"""data"":{");
                sb.Append(@"""first"":{");
                sb.Append(@"""value"":""");
                sb.Append(msgPrm.firstPrm.value);
                sb.Append(@"""");
                if (!string.IsNullOrEmpty(msgPrm.firstPrm.color))
                {
                    sb.Append(@",""color"":""");
                    sb.Append(msgPrm.firstPrm.color);
                    sb.Append(@"""");
                }
                sb.Append("},");

                List<ContBean> conts = msgPrm.keywordsPrm;

                if (null != conts && conts.Count > 0)
                {
                    for (int i = 0; i < conts.Count; i++)
                    {
                        sb.Append(@"""keyword");
                        sb.Append((i + 1).ToString());
                        sb.Append(@""":{");
                        sb.Append(@"""value"":""");
                        sb.Append(conts[i].value);
                        sb.Append(@"""");
                        if (!string.IsNullOrEmpty(conts[i].color))
                        {
                            sb.Append(@",""color"":""");
                            sb.Append(conts[i].color);
                            sb.Append(@"""");
                        }
                        sb.Append("},");
                    }
                }
                sb.Append(@"""remark"":{");
                sb.Append(@"""value"":""");
                sb.Append(msgPrm.remarkPrm.value);
                sb.Append(@"""");
                if (!string.IsNullOrEmpty(msgPrm.remarkPrm.color))
                {
                    sb.Append(@",""color"":""");
                    sb.Append(msgPrm.remarkPrm.color);
                    sb.Append(@"""");
                }
                sb.Append("}}}");

                using (StreamWriter dataStream = new StreamWriter(request.GetRequestStream()))
                {
                    dataStream.Write(sb.ToString());
                    dataStream.Close();
                }
                HttpWebResponse response = (HttpWebResponse)request.GetResponse();
                Stream myResponseStream = response.GetResponseStream();
                StreamReader myStreamReader = new StreamReader(myResponseStream, Encoding.UTF8);
                string retString = myStreamReader.ReadToEnd();
                myStreamReader.Close();
                myResponseStream.Close();

                //解析josn
                //JObject jso = (JObject)JsonConvert.DeserializeObject(retString);
                //string rtnCode = jso["errcode"].ToString();
                //string rtnMsg = jso["errmsg"].ToString();
                //Logger.WriteLineInfo("------------send msg return code is:" + rtnCode + ", return msg is:" + rtnMsg +
                //                     ", json string is:" + sb.ToString());
            }
            catch (Exception ex)
            {
                Logger.WriteLineError("----------push wechat message failed:" + ex.Message + "-----------");
            }
        }
    }

    public class MessagePushHelper : IDisposable
    {
        private readonly int _signId;
        private readonly bool _sendMessage = false;
        private static JPushClient _jpushClient;
        private static JSMSClient _jsmsClient;

        public MessagePushHelper(string appkey, string appsecret, int signid, int issendSMS)
        {
            _jpushClient = new JPushClient(appkey, appsecret);
            _jsmsClient = new JSMSClient(appkey, appsecret);
            _signId = signid;
            _sendMessage = issendSMS == 1;
        }

        public PushMessageResult PushMessage(siger_app_project_message message, bool isOnline, string toUserKey, string mobile, int templateId, Dictionary<string, string> paras)
        {
            if (isOnline)
            {
                if (string.IsNullOrWhiteSpace(toUserKey))
                {
                    return PushMessageResult.UserAppKeyIsEmpty;
                }

                if (PushOnLineMessage(toUserKey, message.title, message.content, message))
                {
                    return PushMessageResult.SendSuccessful;
                }

                return PushMessageResult.PushMessageFailed;
            }
            else
            {
                if (!_sendMessage)
                {
                    return PushMessageResult.SendSMSFailed;
                }
                if (string.IsNullOrWhiteSpace(mobile))
                {
                    return PushMessageResult.UserMobileIsEmpty;
                }

                if (SendSMSMessage(mobile, templateId, paras))
                {
                    return PushMessageResult.SendSuccessful;
                }
                return PushMessageResult.SendSMSFailed;
            }
        }

        public bool PushOnLineMessage(string appKey, string title, string content, siger_app_project_message message)
        {
            return ExecutePush(appKey, title, content, message);
        }

        public bool SendSMSMessage(string mobile, int templateId, Dictionary<string, string> paras)
        {
            if (paras == null)
            {
                Logger.WriteLineWarn("paras is null.");
                return false;
            }
            if (templateId <= 0)
            {
                Logger.WriteLineWarn("get sms massage template failed.");
                return false;
            }

            return ExecuteSendSMS(mobile, templateId, paras);
        }

        private bool ExecutePush(string registerId, string title, string content, siger_app_project_message message)
        {
            var audience =
                new Dictionary<string, List<string>> { { "registration_id", new List<string> { registerId } } };
            PushPayload pushPayload = new PushPayload()
            {
                Platform = new List<string> { "android", "ios" },
                Audience = audience,
                Notification = new Notification
                {
                    Alert = title,
                    Android = new Android
                    {
                        Alert = content,
                        Title = title,
                        BuilderId = 1,
                        Extras = new Dictionary<string, object>
                        {
                            { "msgid", message.id },
                            { "msgtype", message.type }
                        }
                    },
                    IOS = new IOS
                    {
                        Alert = new Dictionary<string, string>
                        {
                            { "title", title },
                            { "body", content }
                        },
                        Sound = "sound.caf",
                        Badge = "+1",
                        Extras = new Dictionary<string, object>
                        {
                            { "msgid", message.id },
                            { "msgtype", message.type }
                        }
                    }
                },
                //Message = new Message
                //{
                //    Title = title,
                //    Content = content
                //},
                Options = new Options
                {
                    IsApnsProduction = true, //指定 APNS 通知发送环境
                    SendNo = UnixTimeHelper.GetNow(),
                    TimeToLive = 86400 //保存离线时间的秒数默认为一天
                }
            };
            try
            {
                var response = _jpushClient.SendPush(pushPayload);
                if (response.StatusCode == HttpStatusCode.OK)
                {
                    return true;
                }
                Logger.WriteLineError($"ExecutePush to {registerId} failed, message:" + response.Content);
            }
            catch (Exception e)
            {
                Logger.WriteLineError($"ExecutePush to {registerId} failed, error:" + e);
            }

            return false;
        }

        private bool ExecuteSendSMS(string mobile, int templateId, Dictionary<string, string> paras)
        {
            try
            {
                var template = new TemplateMessage
                {
                    SignId = _signId,
                    Mobile = mobile,
                    TemplateId = templateId,
                    Type = 2, // 通知类
                    TemplateParameters = paras
                };
                var response = _jsmsClient.SendTemplateMessage(template);
                if (response.StatusCode == HttpStatusCode.OK)
                {
                    return true;
                }
                Logger.WriteLineError($"ExecutePush to {mobile} failed, message:" + response.Content);
            }
            catch (Exception e)
            {
                Logger.WriteLineError($"ExecutePush to {mobile} failed, error:" + e);
            }

            return false;
        }

        public void Dispose()
        {
            _jpushClient = null;
            _jsmsClient = null;
        }
    }
}
