function formatDecimal (input, coefficient, precision, fixedLength) {
    var strInput = null
    var floatInput = null
    if (input !== null) {
        strInput = input.toString()
        floatInput = parseFloat(strInput.replace(/\s+/g, ''))
    } else {
        return 0
    }
    if (isNaN(floatInput)) {
        return 0
    }
    floatInput = Math.round(floatInput * coefficient * Math.pow(10, precision)) / Math.pow(10, precision)
    if (fixedLength) {
        strInput = floatInput.toString()
        var dotPosition = strInput.indexOf('.')
        if (dotPosition < 0) {
            dotPosition = strInput.length
            strInput += '.'
        }
        while (strInput.length <= dotPosition + precision) {
            strInput += '0'
        }
        return strInput
    }
    return floatInput
}
export default function (Vue) {
    // 添加全局API
    Vue.prototype.$datatype = {
        formatDecimal
    }
}
