import Vue from 'vue'

const changetime = (casex) => { // 日期类型
  var valuemodel
  var now = new Date()
  var nowDayOfWeek = now.getDay() // 今天本周的第几天
  var nowDay = now.getDate() // 当前日
  var nowMonth = now.getMonth() // 当前月
  var nowYear = now.getYear() // 当前年
  nowYear += (nowYear < 2000) ? 1900 : 0 //
  var lastMonthDate = new Date() // 上月日期
  lastMonthDate.setDate(1)
  lastMonthDate.setMonth(lastMonthDate.getMonth() - 1)
  var lastMonth = lastMonthDate.getMonth()
  if (casex === 1) {
    var today = timestampToTime(now.getTime())
    valuemodel = today + ' 00:00:00 - ' + today + ' 23:59:59'
  } else if (casex === 2) {
    var stringDate = timestampToTime(now.getTime() - 24 * 60 * 60 * 1000)
    valuemodel = stringDate + ' 00:00:00 - ' + stringDate + ' 23:59:59'
  } else if (casex === 3) {
    var weekStartDate = new Date(nowYear, nowMonth, nowDay - nowDayOfWeek + 1)
    var weekEndDate = new Date(nowYear, nowMonth, nowDay - nowDayOfWeek + 7)
    valuemodel = formatDate(weekStartDate) + ' 00:00:00 - ' + formatDate(weekEndDate) + ' 23:59:59'
  } else if (casex === 4) {
    var weekStartDate2 = new Date(nowYear, nowMonth, nowDay - nowDayOfWeek - 6)
    var weekEndDate2 = new Date(nowYear, nowMonth, nowDay - nowDayOfWeek)
    valuemodel = formatDate(weekStartDate2) + ' 00:00:00 - ' + formatDate(weekEndDate2) + ' 23:59:59'
  } else if (casex === 5) {
    var monthStartDate = new Date(nowYear, nowMonth, 1)
    var monthEndDate = new Date(nowYear, nowMonth, getMonthDays(nowMonth, nowYear))
    valuemodel = formatDate(monthStartDate) + ' 00:00:00 - ' + formatDate(monthEndDate) + ' 23:59:59'
  } else if (casex === 6) {
    var lastMonthStartDate = new Date(nowYear, lastMonth, 1)
    var lastMonthEndDate = new Date(nowYear, lastMonth, getMonthDays(lastMonth, nowYear))
    valuemodel = formatDate(lastMonthStartDate) + ' 00:00:00 - ' + formatDate(lastMonthEndDate) + ' 23:59:59'
  } else if (casex === 7) {
    valuemodel = nowYear + '-01-01 00:00:00 - ' + nowYear + '-12-31 23:59:59'
  } else {
    valuemodel = (nowYear - 1) + '-01-01 00:00:00 - ' + (nowYear - 1) + '-12-31 23:59:59'
  }
  return valuemodel
}

function formatDate(date) {
  var myyear = date.getFullYear()
  var mymonth = date.getMonth() + 1
  var myweekday = date.getDate()
  if (mymonth < 10) {
    mymonth = '0' + mymonth
  }
  if (myweekday < 10) {
    myweekday = '0' + myweekday
  }
  return (myyear + '-' + mymonth + '-' + myweekday)
}
// 获得某月的天数
function getMonthDays(myMonth, nowYear) {
  var monthStartDate = new Date(nowYear, myMonth, 1)
  var monthEndDate = new Date(nowYear, myMonth + 1, 1)
  var days = (monthEndDate - monthStartDate) / (1000 * 60 * 60 * 24)
  return days
}
// 时间戳 转换
function timestampToTime(timestamp) {
  var date = new Date(timestamp) // 时间戳为10位需*1000，时间戳为13位的话不需乘1000
  var Y = date.getFullYear() + '-'
  var M = (date.getMonth() + 1 < 10 ? '0' + (date.getMonth() + 1) : date.getMonth() + 1) + '-'
  var D = (date.getDate() < 10 ? '0' + (date.getDate()) : date.getDate()) + ' '
  return Y + M + D
}
// 时间戳 转换
function timestampToTimeSpan(timestamp) {
  var date = new Date(timestamp * 1000) // 时间戳为10位需*1000，时间戳为13位的话不需乘1000
  var Y = date.getFullYear() + '-'
  var M = (date.getMonth() + 1 < 10 ? '0' + (date.getMonth() + 1) : date.getMonth() + 1) + '-'
  var D = (date.getDate() < 10 ? '0' + date.getDate() : date.getDate()) + ' '
  var h = (date.getHours() < 10 ? '0' + date.getHours() : date.getHours()) + ':'
  var m = (date.getMinutes() < 10 ? '0' + date.getMinutes() : date.getMinutes()) + ':'
  var s = (date.getSeconds() < 10 ? '0' + date.getSeconds() : date.getSeconds())
  return Y + M + D + h + m + s
}

function getDate(day, type) {
  var zdate = new Date()
  var edate
  if (type === 1) {
    edate = new Date(zdate.getTime() - (day * 24 * 60 * 60 * 1000))
  } else {
    edate = new Date(zdate.getTime() + (day * 24 * 60 * 60 * 1000))
  }
  var ymdDate
  var month = edate.getMonth() + 1
  if (month < 10) {
    month = '0' + month.toString()
  } else {
    month = month.toString()
  }
  var day2 = edate.getDate()
  if (day2 < 10) {
    day = '0' + day2.toString()
  } else {
    day = day2.toString()
  }
  ymdDate = (edate.getFullYear()).toString() + '-' + month + '-' + day
  // return edate;
  return ymdDate
}

function datestrtotime(datetime) {
  var date = new Date(datetime)
  var time = date.getTime()
  return time / 1000
}

function deepClone(data) {
  var leg = Object.prototype.toString.call(data).toString().length // 6月30号改的类型判断
  var type = Object.prototype.toString.call(data).toString().slice(8, leg - 1)
  // var type = typeof (data) //第一版的类型判断
  var obj
  if (type === 'Array') {
    obj = []
  } else if (type === 'Object') {
    obj = {}
  } else {
    // 不再具有下一层次
    return data
  }
  if (type === 'Array') {
    for (var i = 0, len = data.length; i < len; i++) {
      obj.push(deepClone(data[i]))
    }
  } else if (type === 'Object') {
    for (var key in data) {
      obj[key] = deepClone(data[key])
    }
  }
  return obj
}

function removezero(obj) { // 根据一个关键数据，移除不必要的数据
  if (obj.y2) {
    obj.arr = []
    obj.arr1 = []
    obj.arr2 = []
    obj.y2.forEach((item, index) => {
      if (item !== 0 || obj.y1[index] !== 0) {
        obj.arr2.push(item)
        obj.arr.push(obj.x[index])
        obj.arr1.push(obj.y1[index])
      }
    })
  } else {
    obj.arr = []
    obj.arr1 = []
    obj.y1.forEach((item, index) => {
      if (item !== 0) {
        obj.arr1.push(item)
        obj.arr.push(obj.x[index])
      }
    })
  }
  return obj
}

function removezero_a(obj) { // 人员工作绩效分析——》人员工作量分析移除不必要的数据，移除不必要的数据
  if (obj.dataXList[0].length > 0) {
    obj.arr = []
    obj.arr_y = []
    var arr1 = []
    var arr2 = []
    var arr3 = []
    var arr4 = []
    obj.dataXList[0].forEach((item, index) => {
      if (item !== 0 || obj.dataXList[1][index] !== 0 || obj.dataXList[2][index] !== 0 || obj.dataXList[3][index] !== 0) {
        arr1.push(item)
        arr2.push(obj.dataXList[1][index])
        arr3.push(obj.dataXList[2][index])
        arr4.push(obj.dataXList[3][index])
        obj.arr_y.push(obj.dataY[index])
      }
    })
    obj.arr.push(arr1, arr2, arr3, arr4)
  }

  return obj
}

function initTableTitle(obj) {
  if (obj.length > 0) {
    obj.forEach((item, index) => {
      if (index === 0) {
        // obj[index].width = 80 // 固定宽度
        Vue.set(obj[index], 'width', 80)
      } else {
        obj[index].minWidth = 100 // 最小宽度
        // obj[index].maxWidth = 200 // 最大宽度
        // obj[index].align = 'left' // 向左对齐
        // obj[index].tooltip = true // 超过宽度显示省略号
        Vue.set(obj[index], 'tooltip', true)
      }
    })
  }

  return obj
}
export default function (Vue) {
  // 添加全局API
  Vue.prototype.$time = {
    changetime,
    timestampToTime,
    timestampToTimeSpan,
    getDate,
    datestrtotime,
    deepClone,
    removezero,
    removezero_a,
    initTableTitle // 初始化table列表
  }
}
