// import Main from '@/components/main'
// import parentView from '@/components/parent-view'
// import store from '@/store'
// import { dynamicRouterAdd } from '@/libs/router-util'

/**
 * iview-admin中meta除了原生参数外可配置的参数:
 * meta: {
 *  title: { String|Number|Function }
 *         显示在侧边栏、面包屑和标签栏的文字
 *         使用'{{ 多语言字段 }}'形式结合多语言使用，例子看多语言的路由配置;
 *         可以传入一个回调函数，参数是当前路由对象，例子看动态路由和带参路由
 *  hideInBread: (false) 设为true后此级路由将不会出现在面包屑中，示例看QQ群路由配置
 *  hideInMenu: (false) 设为true后在左侧菜单不会显示该页面选项
 *  notCache: (false) 设为true后页面在切换标签后不会缓存，如果需要缓存，无需设置这个字段，而且需要设置页面组件name属性和路由配置的name一致
 *  access: (null) 可访问该页面的权限数组，当前路由设置的权限会影响子路由
 *  icon: (-) 该页面在左侧菜单、面包屑和标签导航处显示的图标，如果是自定义图标，需要在图标名称前加下划线'_'
 *  beforeCloseName: (-) 设置该字段，则在关闭当前tab页时会去'@/router/before-close.js'里寻找该字段名对应的方法，作为关闭前的钩子函数
 * }
 */

import Main from '@/components/main'
import {
  dynamicRouterAdd
} from '@/libs/router-util' // ①添 引入加载菜单

// 不作为Main组件的子页面展示的页面单独写
export const otherRouter = [{
    path: '/login',
    name: 'login',
    meta: {
      hideInMenu: true
    },
    component: () => import('@/view/login/login.vue')
  },
  {
    path: '/401',
    name: 'error_401',
    meta: {
      hideInMenu: true
    },
    component: () => import('@/view/error-page/401.vue')
  },
  {
    path: '*',
    name: 'error_404',
    meta: {
      hideInMenu: true
    },
    component: () => import('@/view/error-page/404.vue')
  },
  {
    path: '/500',
    name: 'error_500',
    meta: {
      hideInMenu: true
    },
    component: () => import('@/view/error-page/500.vue')
  },
  {
    path: '/audit',
    name: 'audit',
    meta: {
      hideInMenu: true
    },
    component: () => import('@/view/other/audit.vue')
  },
  {
    path: '/mtsSearch',
    name: 'mtsSearch',
    meta: {
      hideInMenu: true
    },
    component: () => import('@/view/other/mtsSearch.vue')
  },
  {
    path: '/codeDiff',
    name: 'codeDiff',
    meta: {
      hideInMenu: true
    },
    component: () => import('@/view/test-page/code-diff.vue')
  },
  {
    path: '/terminal',
    name: 'terminal',
    meta: {
      hideInMenu: true
    },
    redirect: '/terminal/t_sign',
    component: () => import('@/view/terminal/main.vue'),
    children: [{
        path: 't_sign',
        name: 't_sign',
        component: () => import('@/view/terminal/t_sign.vue'),
      },
      {
        path: 't_woex',
        name: 't_woex',
        component: () => import('@/view/terminal/t_woex.vue')
      },
      {
        path: 't_pgcl',
        name: 't_pgcl',
        component: () => import('@/view/terminal/t_pgcl.vue')
      },
      {
        path: 't_rtdw',
        name: 't_rtdw',
        component: () => import('@/view/terminal/t_rtdw.vue')
      },
      {
        path: 't_admg',
        name: 't_admg',
        component: () => import('@/view/terminal/t_admg.vue')
      },
      {
        path: 't_qtck',
        name: 't_qtck',
        component: () => import('@/view/terminal/t_qtck.vue')
      },
      {
        path: 't_mcoe',
        name: 't_mcoe',
        component: () => import('@/view/terminal/t_mcoe.vue')
      }
    ]
  }
]

// 作为Main组件的子页面展示但是不在左侧菜单显示的路由写在mainRouter里
export const mainRouter = [{
  path: '/',
  name: '_home',
  redirect: '/home',
  component: Main,
  meta: {
    hideInMenu: true,
    notCache: true
  },
  children: [{
    path: '/home',
    name: 'home',
    meta: {
      hideInMenu: true,
      title: '首页',
      notCache: true,
      icon: 'md-home'
    },
    component: () => import('@/view/single-page/home')
  }]
}, {
  path: '/message',
  name: 'message',
  component: Main,
  meta: {
    hideInBread: true,
    hideInMenu: true
  },
  children: [{
    path: 'message_page',
    name: 'message_page',
    meta: {
      icon: 'md-notifications',
      title: '消息中心'
    },
    component: () => import('@/view/single-page/message/index.vue')
  }]
}]

// 作为Main组件的子页面展示并且在左侧菜单显示的路由写在appRouter里
export const appRouter = [...dynamicRouterAdd()]
export const routes = [
  ...otherRouter,
  ...mainRouter,
  ...appRouter
]

// 所有上面定义的路由都要写在下面输出
export default routes
