import {
    getBreadCrumbList,
    setTagNavListInLocalstorage,
    getMenuByRouter,
    getTagNavListFromLocalstorage,
    getHomeRoute,
    getNextRoute,
    routeHasExist,
    routeEqual,
    getRouteTitleHandled,
    localSave,
    localRead
} from '@/libs/util'
import { saveErrorLogger } from '@/api/data'
import router from '@/router'
import config from '@/config'
import axios from '@/libs/api.request'
const { homeName } = config

const closePage = (state, route) => {
    const nextRoute = getNextRoute(state.tagNavList, route)
    state.tagNavList = state.tagNavList.filter(item => {
        return !routeEqual(item, route)
    })
    router.push(nextRoute)
}

export default {
    state: {
        breadCrumbList: [],
        tagNavList: [],
        homeRoute: {},
        local: localRead('local'),
        errorList: [],
        hasReadErrorPage: false,
        menuList: [],
        tree: [],
        test: '123'
    },
    getters: {
    // menuList: (state, getters, rootState) => getMenuByRouter(routers, rootState.user.access),
    // errorCount: state => state.errorList.length
        menuList: (state, getters, rootState) =>
            getMenuByRouter(state.menuList, rootState.user.access),
        errorCount: state => state.errorList.length
    },
    mutations: {
        updateMenuList (state, routes) {
            // 添接受前台数组，刷新菜单
            router.addRoutes(routes) // 动态添加路由
            state.menuList = routes
            // console.log('updateMenuList 添  menuList', state.menuList)
        },

        setBreadCrumb (state, route) {
            state.breadCrumbList = getBreadCrumbList(route, state.homeRoute)
        },
        setHomeRoute (state, routes) {
            state.homeRoute = getHomeRoute(routes, homeName)
        },
        setTagNavList (state, list) {
            let tagList = []
            if (list) {
                tagList = [...list]
            } else tagList = getTagNavListFromLocalstorage() || []
            if (tagList[0] && tagList[0].name !== homeName) tagList.shift()
            let homeTagIndex = tagList.findIndex(item => item.name === homeName)
            if (homeTagIndex > 0) {
                let homeTag = tagList.splice(homeTagIndex, 1)[0]
                tagList.unshift(homeTag)
            }
            state.tagNavList = tagList
            setTagNavListInLocalstorage([...tagList])
        },
        closeTag (state, route) {
            let tag = state.tagNavList.filter(item => routeEqual(item, route))
            route = tag[0] ? tag[0] : null
            if (!route) return
            closePage(state, route)
        },
        addTag (state, { route, type = 'unshift' }) {
            let router = getRouteTitleHandled(route)
            if (!routeHasExist(state.tagNavList, router)) {
                if (type === 'push') state.tagNavList.push(router)
                else {
                    if (router.name === homeName) state.tagNavList.unshift(router)
                    else state.tagNavList.splice(1, 0, router)
                }
                setTagNavListInLocalstorage([...state.tagNavList])
            }
        },
        setLocal (state, lang) {
            localSave('local', lang)
            state.local = lang
        },
        addError (state, error) {
            state.errorList.push(error)
        },
        setHasReadErrorLoggerStatus (state, status = true) {
            state.hasReadErrorPage = status
        },
        getTree (state, res) {
            function modify (result) {
                result.map(ele => {
                    if (ele.children) { // 递归调用
                        modify(ele.children);
                    }
                    ele.title = ele.label;
                    ele.expand = true;
                    return ele;
                });
                return result;
            }
            modify(res);
            state.tree = res;
        }
    },
    actions: {
        addErrorLog ({ commit, rootState }, info) {
            if (!window.location.href.includes('error_logger_page')) commit('setHasReadErrorLoggerStatus', false)
            const { user: { token, userId, userName } } = rootState
            let data = {
                ...info,
                time: Date.parse(new Date()),
                token,
                userId,
                userName
            }
            saveErrorLogger(info).then(() => {
                commit('addError', data)
            })
        },
        getTree (context) {
            axios.request({ url: '/config/ProjectLevelSection/GetSectionTree', method: 'get' }).then(res => {
                context.commit('getTree', res.data.data)
            })
        }
    }
}
