﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Siger.ApiCommon.Utilities;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.AppSettings;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.ApiCommon.Filters;
namespace Siger.ApiFlowMetek.Controllers
{
    [Consumes("application/json", "multipart/form-data")]
    [Route("FlowMetek/[controller]/[action]")]
    [ApiController]
    public class UploadController : ControllerBase
    {
        [NoTokenValidateFilter]
        [HttpPost]
        public IActionResult Attchment(IFormFile formFile)
        {
            if (Request.Form?.Files == null)
            {
                throw new BadRequestException(ConfigEnum.UploadFileNotFound);
            }

            var date = DateTime.Now.ToString("yyyy-MM-dd");

            var rootDir = FileSystemHelper.GetPhysicalFolders(FileSystemHelper.CommonFileSetting.PhysicalFolder, "attchment", date);
          
            var files = Request.Form.Files;
            var file = files[0];
            //var temporaryFileName = Guid.NewGuid().ToString("N") + FileHelper.GetExtension(file.FileName);
            var temporaryFileName = file.FileName;
            var fileName = Path.Combine(rootDir, temporaryFileName);

            using (var stream = new FileStream(fileName, FileMode.Create))
            {
                file.CopyTo(stream);
            }

            return new ObjectResult($"{FileSystemHelper.CommonFileSetting.RequestPath}/attchment/{date}/{temporaryFileName}");
        }
    }
}