using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Hosting;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.Hosting;
using Microsoft.Extensions.Logging;

namespace Siger.ApiFlowMetek
{
    public class Program
    {
        public static void Main(string[] args)
        {
            CreateHostBuilder(args).Build().Run();
        }

        public static IHostBuilder CreateHostBuilder(string[] args) =>
                   Host.CreateDefaultBuilder(args).ConfigureAppConfiguration(builder =>
                   {
                       builder.AddJsonFile("appsettings.json", optional: true);
                   })
              .ConfigureWebHostDefaults(webBuilder =>
              {
                  webBuilder.UseUrls(args.Length > 1 ? $"http://*:{args[1]}" : "http://*:7104");
                  webBuilder.UseStartup<Startup>();
              });
    }
}
