﻿using System.Collections.Generic;
using System.Linq;
using Microsoft.AspNetCore.Mvc;
using Siger.ApiCommon;
using Siger.Middlelayer.Repository.Entities;

namespace Siger.ApiACC.Controllers
{
    [Route("acc/[controller]/[action]")]
    public class BaseController : AuthController
    {
        public static string GetChannelSection(int sectionid, List<siger_project_level_section> levelSections)
        {
            string location = "";
            var section = levelSections.FirstOrDefault(t => t.id == sectionid);
            if (section != null)
            {
                location = section.title;
                var channel = levelSections.FirstOrDefault(t => t.id == section.parentid);
                if (channel != null)
                {
                    location = $"{channel.title}-{section.title}";
                }
            }
            return location;
        }
    }
}