﻿using System.Linq;
using Microsoft.AspNetCore.Mvc;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Repositories.Interface;

namespace Siger.ApiACC.Controllers
{
    public class PositionController : BaseController
    {
        private readonly ISigerProjectLevelSectionRepository _projectLevelSection;
        public PositionController(ISigerProjectLevelSectionRepository projectLevelSection)
        {
            _projectLevelSection = projectLevelSection;
        }

        [HttpGet]
        public IActionResult GetLine()
        {
            var result = _projectLevelSection.GetAccLines(ProjectId);
            if (result.Any())
                return new ObjectResult(result);
            throw new BadRequestException(CommonEnum.RecordNotFound);
        }

        [HttpGet]
        public IActionResult GetStation(int line)
        {
            var obj = _projectLevelSection.GetAccStationByline(ProjectId, line);
            if (obj.Any())
                return new ObjectResult(obj);
            throw new BadRequestException(CommonEnum.RecordNotFound);
        }
    }

}