﻿using Microsoft.AspNetCore.Mvc;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.AccRepository.Request;
using Siger.Middlelayer.Common;

namespace Siger.ApiACC.Controllers.Report
{
    public class PackingController : BaseController
    {
        private readonly ISigerTrPackBoxListRepository _packBoxListRepository;
        private readonly ISigerTrPackBoxSNListRepository _packBoxSnListRepository;

        public PackingController(IUnitOfWork unitOfWork, ISigerTrPackBoxListRepository packBoxListRepository, ISigerTrPackBoxSNListRepository packBoxSnListRepository)
        {
            _packBoxListRepository = packBoxListRepository;
            _packBoxSnListRepository = packBoxSnListRepository;
        }
        [HttpPost]
        public ActionResult GetData([FromBody]RequestACCRpt rpt)
        {
            if (rpt.Category != AccEnum.Packing)
            {
                throw new BadRequestException(AccEnum.Msg_Category_Err);
            }
            switch (rpt.Rpt)
            {
                case AccEnum.Packing_BoxList:
                    {
                        var result = _packBoxListRepository.GetPagedList(rpt.Offset, rpt.Limit, f => f.BoxID == rpt.Number);

                        return new ObjectResult(result);
                    }
                case AccEnum.Packing_BoxSnlist:
                    {
                        var result = _packBoxSnListRepository.GetPagedList(rpt.Offset, rpt.Limit, f => f.BoxID == rpt.Number);

                        return new ObjectResult(result);
                    }
                case AccEnum.Packing_BoxHistory:
                    {
                        var result = _packBoxListRepository.GetPagedList(rpt.Offset, rpt.Limit, f => f.BoxID == rpt.Number && f.status== Packing_Status.Clear.GetHashCode());

                        return new ObjectResult(result);
                    }
                default:
                    {
                        throw new BadRequestException(AccEnum.Msg_Rpt_Null);
                    }
            }
        }
    }
}