﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using Microsoft.AspNetCore.Mvc;
using Siger.ApiCommon;
using Siger.ApiCommon.Utilities;
using Siger.Middlelayer.CncRepository.Response;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.AppSettings;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Log;
using Siger.Middlelayer.Utility.Helpers;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.ApiCNC.Controllers
{
    [Route("cnc/[controller]/[action]")]
    public class BaseController : AuthController
    {
        [HttpPost]
        public IActionResult ExportBarChart(List<ResponseGetAlarmDataForAnalysis> responses, int language,int type)
        {
            if (!responses.Any())
            {
                throw new BadRequestException(CommonEnum.RecordNotFound);
            }

            var rootDir = FileSystemHelper.GetPhysicalFolders(FileSystemHelper.CommonFileSetting.PhysicalFolder, FileSystemHelper.ExportFileName);
            var temporaryFileName = $"BarChart_{DateTime.Now:yyyyMMddHHmmss}.xlsx";
            var fileName = Path.Combine(rootDir, temporaryFileName);

            dynamic helper;
            switch (type)
            {
                case 1:
                    helper = new EpPlusExcelHelper<BarChart1>(language);
                    try
                    {
                        var machineYields = new List<BarChart1>();
                        var index = 1;
                        foreach (var yield in responses)
                        {
                            var machineYield = new BarChart1
                            {
                                No = index,
                                Abscissa = yield.Abscissa,
                                Ordinates = Math.Round(yield.Ordinate, 0).ToStr()
                            };
                            machineYields.Add(machineYield);
                            index++;
                        }

                        helper.GenerateExcel(machineYields, fileName);
                        return new ObjectResult($"{FileSystemHelper.CommonFileSetting.RequestPath}/{FileSystemHelper.ExportFileName}/{temporaryFileName}");
                    }
                    catch (Exception e)
                    {
                        Logger.WriteLineError("ExportBarChart failed, error: " + e.Message);
                        throw new BadRequestException(RequestEnum.ExportFailed);
                    }
                    finally
                    {
                        helper.Dispose();
                    }
                case 2:
                    helper = new EpPlusExcelHelper<BarChart2>(language);
                    try
                    {
                        var machineYields = new List<BarChart2>();
                        var index = 1;
                        foreach (var yield in responses)
                        {
                            var machineYield = new BarChart2
                            {
                                No = index,
                                Abscissa = yield.Abscissa,
                                Ordinates = Math.Round(yield.Ordinate, 0).ToStr()
                            };
                            machineYields.Add(machineYield);
                            index++;
                        }

                        helper.GenerateExcel(machineYields, fileName);
                        return new ObjectResult($"{FileSystemHelper.CommonFileSetting.RequestPath}/{FileSystemHelper.ExportFileName}/{temporaryFileName}");
                    }
                    catch (Exception e)
                    {
                        Logger.WriteLineError("ExportBarChart failed, error: " + e.Message);
                        throw new BadRequestException(RequestEnum.ExportFailed);
                    }
                    finally
                    {
                        helper.Dispose();
                    }
                case 3:
                    helper = new EpPlusExcelHelper<BarChart3>(language);
                    try
                    {
                        var machineYields = new List<BarChart3>();
                        var index = 1;
                        foreach (var yield in responses)
                        {
                            var machineYield = new BarChart3
                            {
                                No = index,
                                Abscissa = yield.Abscissa,
                                Ordinates = Math.Round(yield.Ordinate, 0).ToStr()
                            };
                            machineYields.Add(machineYield);
                            index++;
                        }

                        helper.GenerateExcel(machineYields, fileName);
                        return new ObjectResult($"{FileSystemHelper.CommonFileSetting.RequestPath}/{FileSystemHelper.ExportFileName}/{temporaryFileName}");
                    }
                    catch (Exception e)
                    {
                        Logger.WriteLineError("ExportBarChart failed, error: " + e.Message);
                        throw new BadRequestException(RequestEnum.ExportFailed);
                    }
                    finally
                    {
                        helper.Dispose();
                    }
                case 4:
                    helper = new EpPlusExcelHelper<BarChart4>(language);
                    try
                    {
                        var machineYields = new List<BarChart4>();
                        var index = 1;
                        foreach (var yield in responses)
                        {
                            var machineYield = new BarChart4
                            {
                                No = index,
                                Abscissa = yield.Abscissa,
                                Ordinates = Math.Round(yield.Ordinate, 0).ToStr()
                            };
                            machineYields.Add(machineYield);
                            index++;
                        }

                        helper.GenerateExcel(machineYields, fileName);
                        return new ObjectResult($"{FileSystemHelper.CommonFileSetting.RequestPath}/{FileSystemHelper.ExportFileName}/{temporaryFileName}");
                    }
                    catch (Exception e)
                    {
                        Logger.WriteLineError("ExportBarChart failed, error: " + e.Message);
                        throw new BadRequestException(RequestEnum.ExportFailed);
                    }
                    finally
                    {
                        helper.Dispose();
                    }
                case 5:
                    helper = new EpPlusExcelHelper<BarChart5>(language);
                    try
                    {
                        var machineYields = new List<BarChart5>();
                        var index = 1;
                        foreach (var yield in responses)
                        {
                            var machineYield = new BarChart5
                            {
                                No = index,
                                Abscissa = yield.Abscissa,
                                //Ordinates = Math.Round(yield.Ordinate, 0).ToStr()
                            };
                            machineYield.Ordinates = UnixTimeHelper.GetTimeBySecond((int)yield.Ordinate);
                            machineYields.Add(machineYield);
                            index++;
                        }

                        helper.GenerateExcel(machineYields, fileName);
                        return new ObjectResult($"{FileSystemHelper.CommonFileSetting.RequestPath}/{FileSystemHelper.ExportFileName}/{temporaryFileName}");
                    }
                    catch (Exception e)
                    {
                        Logger.WriteLineError("ExportBarChart failed, error: " + e.Message);
                        throw new BadRequestException(RequestEnum.ExportFailed);
                    }
                    finally
                    {
                        helper.Dispose();
                    }
                case 6:
                    helper = new EpPlusExcelHelper<BarChart6>(language);
                    try
                    {
                        var machineYields = new List<BarChart6>();
                        var index = 1;
                        foreach (var yield in responses)
                        {
                            var machineYield = new BarChart6
                            {
                                No = index,
                                Abscissa = yield.Abscissa,
                                //Ordinates = Math.Round(yield.Ordinate, 0).ToStr()
                            };
                            machineYield.Ordinates = UnixTimeHelper.GetTimeBySecond((int)yield.Ordinate);
                            machineYields.Add(machineYield);
                            index++;
                        }

                        helper.GenerateExcel(machineYields, fileName);
                        return new ObjectResult($"{FileSystemHelper.CommonFileSetting.RequestPath}/{FileSystemHelper.ExportFileName}/{temporaryFileName}");
                    }
                    catch (Exception e)
                    {
                        Logger.WriteLineError("ExportBarChart failed, error: " + e.Message);
                        throw new BadRequestException(RequestEnum.ExportFailed);
                    }
                    finally
                    {
                        helper.Dispose();
                    }
                case 7:
                    helper = new EpPlusExcelHelper<BarChart7>(language);
                    try
                    {
                        var machineYields = new List<BarChart7>();
                        var index = 1;
                        foreach (var yield in responses)
                        {
                            var machineYield = new BarChart7
                            {
                                No = index,
                                Abscissa = yield.Abscissa,
                                //Ordinates = Math.Round(yield.Ordinate, 0).ToStr()
                            };
                            machineYield.Ordinates = UnixTimeHelper.GetTimeBySecond((int)yield.Ordinate);
                            machineYields.Add(machineYield);
                            index++;
                        }

                        helper.GenerateExcel(machineYields, fileName);
                        return new ObjectResult($"{FileSystemHelper.CommonFileSetting.RequestPath}/{FileSystemHelper.ExportFileName}/{temporaryFileName}");
                    }
                    catch (Exception e)
                    {
                        Logger.WriteLineError("ExportBarChart failed, error: " + e.Message);
                        throw new BadRequestException(RequestEnum.ExportFailed);
                    }
                    finally
                    {
                        helper.Dispose();
                    }
                case 8:
                    helper = new EpPlusExcelHelper<BarChart8>(language);
                    try
                    {
                        var machineYields = new List<BarChart8>();
                        var index = 1;
                        foreach (var yield in responses)
                        {
                            var machineYield = new BarChart8
                            {
                                No = index,
                                Abscissa = yield.Abscissa,
                                //Ordinates = Math.Round(yield.Ordinate, 0).ToStr()
                            };
                            machineYield.Ordinates = UnixTimeHelper.GetTimeBySecond((int)yield.Ordinate);
                            machineYields.Add(machineYield);
                            index++;
                        }

                        helper.GenerateExcel(machineYields, fileName);
                        return new ObjectResult($"{FileSystemHelper.CommonFileSetting.RequestPath}/{FileSystemHelper.ExportFileName}/{temporaryFileName}");
                    }
                    catch (Exception e)
                    {
                        Logger.WriteLineError("ExportBarChart failed, error: " + e.Message);
                        throw new BadRequestException(RequestEnum.ExportFailed);
                    }
                    finally
                    {
                        helper.Dispose();
                    }
                case 9:
                    helper = new EpPlusExcelHelper<BarChart9>(language);
                    try
                    {
                        var machineYields = new List<BarChart9>();
                        var index = 1;
                        foreach (var yield in responses)
                        {
                            var machineYield = new BarChart9
                            {
                                No = index,
                                Abscissa = yield.Abscissa,
                                Ordinates = Math.Round(yield.Ordinate, 0).ToStr()
                            };
                            machineYields.Add(machineYield);
                            index++;
                        }

                        helper.GenerateExcel(machineYields, fileName);
                        return new ObjectResult($"{FileSystemHelper.CommonFileSetting.RequestPath}/{FileSystemHelper.ExportFileName}/{temporaryFileName}");
                    }
                    catch (Exception e)
                    {
                        Logger.WriteLineError("ExportBarChart failed, error: " + e.Message);
                        throw new BadRequestException(RequestEnum.ExportFailed);
                    }
                    finally
                    {
                        helper.Dispose();
                    }
                case 10:
                    helper = new EpPlusExcelHelper<BarChart10>(language);
                    try
                    {
                        var machineYields = new List<BarChart10>();
                        var index = 1;
                        foreach (var yield in responses)
                        {
                            var machineYield = new BarChart10
                            {
                                No = index,
                                Abscissa = yield.Abscissa,
                                Ordinates = Math.Round(yield.Ordinate, 0).ToStr()
                            };
                            machineYields.Add(machineYield);
                            index++;
                        }

                        helper.GenerateExcel(machineYields, fileName);
                        return new ObjectResult($"{FileSystemHelper.CommonFileSetting.RequestPath}/{FileSystemHelper.ExportFileName}/{temporaryFileName}");
                    }
                    catch (Exception e)
                    {
                        Logger.WriteLineError("ExportBarChart failed, error: " + e.Message);
                        throw new BadRequestException(RequestEnum.ExportFailed);
                    }
                    finally
                    {
                        helper.Dispose();
                    }
                case 11:
                    helper = new EpPlusExcelHelper<BarChart11>(language);
                    try
                    {
                        var machineYields = new List<BarChart11>();
                        var index = 1;
                        foreach (var yield in responses)
                        {
                            var machineYield = new BarChart11
                            {
                                No = index,
                                Abscissa = yield.Abscissa,
                                Ordinates = yield.Ordinate>0? Math.Round(yield.Ordinate/60, 2).ToStr():"0.00",
                            };
                           // machineYield.Ordinates = UnixTimeHelper.GetTimeBySecond((int)yield.Ordinate);
                            machineYields.Add(machineYield);
                            index++;
                        }

                        helper.GenerateExcel(machineYields, fileName);
                        return new ObjectResult($"{FileSystemHelper.CommonFileSetting.RequestPath}/{FileSystemHelper.ExportFileName}/{temporaryFileName}");
                    }
                    catch (Exception e)
                    {
                        Logger.WriteLineError("ExportBarChart failed, error: " + e.Message);
                        throw new BadRequestException(RequestEnum.ExportFailed);
                    }
                    finally
                    {
                        helper.Dispose();
                    }
                case 12:
                    helper = new EpPlusExcelHelper<BarChart12>(language);
                    try
                    {
                        var machineYields = new List<BarChart12>();
                        var index = 1;
                        foreach (var yield in responses)
                        {
                            var machineYield = new BarChart12
                            {
                                No = index,
                                Abscissa = yield.Abscissa,
                                Ordinates = yield.Ordinate > 0 ? Math.Round(yield.Ordinate / 60, 2).ToStr() : "0.00",
                            };
                            //machineYield.Ordinates = UnixTimeHelper.GetTimeBySecond((int)yield.Ordinate);
                            machineYields.Add(machineYield);
                            index++;
                        }

                        helper.GenerateExcel(machineYields, fileName);
                        return new ObjectResult($"{FileSystemHelper.CommonFileSetting.RequestPath}/{FileSystemHelper.ExportFileName}/{temporaryFileName}");
                    }
                    catch (Exception e)
                    {
                        Logger.WriteLineError("ExportBarChart failed, error: " + e.Message);
                        throw new BadRequestException(RequestEnum.ExportFailed);
                    }
                    finally
                    {
                        helper.Dispose();
                    }
                case 13:
                    helper = new EpPlusExcelHelper<BarChart13>(language);
                    try
                    {
                        var machineYields = new List<BarChart13>();
                        var index = 1;
                        foreach (var yield in responses)
                        {
                            var machineYield = new BarChart13
                            {
                                No = index,
                                Abscissa = yield.Abscissa,
                                //Ordinates = yield.Ordinate > 0 ? Math.Round(yield.Ordinate / 60, 2).ToStr() : "0.00",
                            };
                            machineYield.Ordinates = UnixTimeHelper.GetTimeBySecond((int)yield.Ordinate*60);
                            machineYields.Add(machineYield);
                            index++;
                        }

                        helper.GenerateExcel(machineYields, fileName);
                        return new ObjectResult($"{FileSystemHelper.CommonFileSetting.RequestPath}/{FileSystemHelper.ExportFileName}/{temporaryFileName}");
                    }
                    catch (Exception e)
                    {
                        Logger.WriteLineError("ExportBarChart failed, error: " + e.Message);
                        throw new BadRequestException(RequestEnum.ExportFailed);
                    }
                    finally
                    {
                        helper.Dispose();
                    }
                case 14:
                    helper = new EpPlusExcelHelper<BarChart14>(language);
                    try
                    {
                        var machineYields = new List<BarChart14>();
                        var index = 1;
                        foreach (var yield in responses)
                        {
                            var machineYield = new BarChart14
                            {
                                No = index,
                                Abscissa = yield.Abscissa,
                               // Ordinates = Math.Round(yield.Ordinate, 0).ToStr()
                            };
                            machineYield.Ordinates = UnixTimeHelper.GetTimeBySecond((int)yield.Ordinate * 60);
                            machineYields.Add(machineYield);
                            index++;
                        }

                        helper.GenerateExcel(machineYields, fileName);
                        return new ObjectResult($"{FileSystemHelper.CommonFileSetting.RequestPath}/{FileSystemHelper.ExportFileName}/{temporaryFileName}");
                    }
                    catch (Exception e)
                    {
                        Logger.WriteLineError("ExportBarChart failed, error: " + e.Message);
                        throw new BadRequestException(RequestEnum.ExportFailed);
                    }
                    finally
                    {
                        helper.Dispose();
                    }
                case 15:
                    helper = new EpPlusExcelHelper<BarChart15>(language);
                    try
                    {
                        var machineYields = new List<BarChart15>();
                        var index = 1;
                        foreach (var yield in responses)
                        {
                            var machineYield = new BarChart15
                            {
                                No = index,
                                Abscissa = yield.Abscissa,
                                //Ordinates = Math.Round(yield.Ordinate, 0).ToStr()
                            };
                            machineYield.Ordinates = UnixTimeHelper.GetTimeBySecond((int)yield.Ordinate * 60);
                            machineYields.Add(machineYield);
                            index++;
                        }

                        helper.GenerateExcel(machineYields, fileName);
                        return new ObjectResult($"{FileSystemHelper.CommonFileSetting.RequestPath}/{FileSystemHelper.ExportFileName}/{temporaryFileName}");
                    }
                    catch (Exception e)
                    {
                        Logger.WriteLineError("ExportBarChart failed, error: " + e.Message);
                        throw new BadRequestException(RequestEnum.ExportFailed);
                    }
                    finally
                    {
                        helper.Dispose();
                    }
                default:
                    helper = new EpPlusExcelHelper<BarChart>(language);
                    try
                    {
                        var machineYields = new List<BarChart>();
                        var index = 1;
                        foreach (var yield in responses)
                        {
                            var machineYield = new BarChart
                            {
                                No = index,
                                Abscissa = yield.Abscissa,
                                Ordinates = Math.Round(yield.Ordinate, 0).ToStr()
                            };
                            machineYields.Add(machineYield);
                            index++;
                        }

                        helper.GenerateExcel(machineYields, fileName);
                        return new ObjectResult($"{FileSystemHelper.CommonFileSetting.RequestPath}/{FileSystemHelper.ExportFileName}/{temporaryFileName}");
                    }
                    catch (Exception e)
                    {
                        Logger.WriteLineError("ExportBarChart failed, error: " + e.Message);
                        throw new BadRequestException(RequestEnum.ExportFailed);
                    }
                    finally
                    {
                        helper.Dispose();
                    }
            }

            throw new BadRequestException(RequestEnum.ExportFailed);
        }

        [HttpPost]
        public IActionResult ExportBarChartCl(List<ResponseGetAlarmDataForAnalysisNew> responses, int language, int type)
        {
            if (!responses.Any())
            {
                throw new BadRequestException(CommonEnum.RecordNotFound);
            }

            var rootDir = FileSystemHelper.GetPhysicalFolders(FileSystemHelper.CommonFileSetting.PhysicalFolder, FileSystemHelper.ExportFileName);
            var temporaryFileName = $"BarChart_{DateTime.Now:yyyyMMddHHmmss}.xlsx";
            var fileName = Path.Combine(rootDir, temporaryFileName);

            dynamic helper;
            switch (type)
            {
                case 1:
                    helper = new EpPlusExcelHelper<BarChartcl1>(language);
                    try
                    {
                        var machineYields = new List<BarChartcl1>();
                        var index = 1;
                        foreach (var yield in responses)
                        {
                            var machineYield = new BarChartcl1
                            {
                                No = index,
                                Abscissa = yield.Abscissa,
                                AbscissaTime=yield.Abscissacl,
                                OrdinatesTime= Math.Round(yield.Ordinatecl, 0).ToStr(),
                                Ordinates = Math.Round(yield.Ordinate, 0).ToStr()
                            };
                            machineYields.Add(machineYield);
                            index++;
                        }

                        helper.GenerateExcel(machineYields, fileName);
                        return new ObjectResult($"{FileSystemHelper.CommonFileSetting.RequestPath}/{FileSystemHelper.ExportFileName}/{temporaryFileName}");
                    }
                    catch (Exception e)
                    {
                        Logger.WriteLineError("ExportBarChart failed, error: " + e.Message);
                        throw new BadRequestException(RequestEnum.ExportFailed);
                    }
                    finally
                    {
                        helper.Dispose();
                    }
                case 2:
                    helper = new EpPlusExcelHelper<BarChartcl2>(language);
                    try
                    {
                        var machineYields = new List<BarChartcl2>();
                        var index = 1;
                        foreach (var yield in responses)
                        {
                            var machineYield = new BarChartcl2
                            {
                                No = index,
                                Abscissa = yield.Abscissa,
                                AbscissaTime=yield.Abscissacl,
                                OrdinatesTime= Math.Round(yield.Ordinatecl, 0).ToStr(),
                                Ordinates = Math.Round(yield.Ordinate, 0).ToStr()
                            };
                            machineYields.Add(machineYield);
                            index++;
                        }

                        helper.GenerateExcel(machineYields, fileName);
                        return new ObjectResult($"{FileSystemHelper.CommonFileSetting.RequestPath}/{FileSystemHelper.ExportFileName}/{temporaryFileName}");
                    }
                    catch (Exception e)
                    {
                        Logger.WriteLineError("ExportBarChart failed, error: " + e.Message);
                        throw new BadRequestException(RequestEnum.ExportFailed);
                    }
                    finally
                    {
                        helper.Dispose();
                    }
                case 3:
                    helper = new EpPlusExcelHelper<BarChartcl3>(language);
                    try
                    {
                        var machineYields = new List<BarChartcl3>();
                        var index = 1;
                        foreach (var yield in responses)
                        {
                            var machineYield = new BarChartcl3
                            {
                                No = index,
                                Abscissa = yield.Abscissa,
                                AbscissaTime=yield.Abscissacl,
                                OrdinatesTime= Math.Round(yield.Ordinatecl, 0).ToStr(),
                                Ordinates = Math.Round(yield.Ordinate, 0).ToStr()
                            };
                            machineYields.Add(machineYield);
                            index++;
                        }

                        helper.GenerateExcel(machineYields, fileName);
                        return new ObjectResult($"{FileSystemHelper.CommonFileSetting.RequestPath}/{FileSystemHelper.ExportFileName}/{temporaryFileName}");
                    }
                    catch (Exception e)
                    {
                        Logger.WriteLineError("ExportBarChart failed, error: " + e.Message);
                        throw new BadRequestException(RequestEnum.ExportFailed);
                    }
                    finally
                    {
                        helper.Dispose();
                    }
                case 4:
                    helper = new EpPlusExcelHelper<BarChartcl4>(language);
                    try
                    {
                        var machineYields = new List<BarChartcl4>();
                        var index = 1;
                        foreach (var yield in responses)
                        {
                            var machineYield = new BarChartcl4
                            {
                                No = index,
                                Abscissa = yield.Abscissa,
                                AbscissaTime=yield.Abscissacl,
                                OrdinatesTime= Math.Round(yield.Ordinatecl, 0).ToStr(),
                                Ordinates = Math.Round(yield.Ordinate, 0).ToStr()
                            };
                            machineYields.Add(machineYield);
                            index++;
                        }

                        helper.GenerateExcel(machineYields, fileName);
                        return new ObjectResult($"{FileSystemHelper.CommonFileSetting.RequestPath}/{FileSystemHelper.ExportFileName}/{temporaryFileName}");
                    }
                    catch (Exception e)
                    {
                        Logger.WriteLineError("ExportBarChart failed, error: " + e.Message);
                        throw new BadRequestException(RequestEnum.ExportFailed);
                    }
                    finally
                    {
                        helper.Dispose();
                    }
                
                default:
                    helper = new EpPlusExcelHelper<BarChartcl>(language);
                    try
                    {
                        var machineYields = new List<BarChartcl>();
                        var index = 1;
                        foreach (var yield in responses)
                        {
                            var machineYield = new BarChartcl
                            {
                                No = index,
                                Abscissa = yield.Abscissa,
                                AbscissaTime=yield.Abscissacl,
                                OrdinatesTime= Math.Round(yield.Ordinatecl, 0).ToStr(),
                                Ordinates = Math.Round(yield.Ordinate, 0).ToStr()
                            };
                            machineYields.Add(machineYield);
                            index++;
                        }

                        helper.GenerateExcel(machineYields, fileName);
                        return new ObjectResult($"{FileSystemHelper.CommonFileSetting.RequestPath}/{FileSystemHelper.ExportFileName}/{temporaryFileName}");
                    }
                    catch (Exception e)
                    {
                        Logger.WriteLineError("ExportBarChart failed, error: " + e.Message);
                        throw new BadRequestException(RequestEnum.ExportFailed);
                    }
                    finally
                    {
                        helper.Dispose();
                    }
            }

            throw new BadRequestException(RequestEnum.ExportFailed);
        }
        /// <summary>
        /// 长龄1.5
        /// </summary>
        /// <param name="responses"></param>
        /// <param name="language"></param>
        /// <param name="type"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult ExportAlarmInfoForEdit(List<ResponseGetMachineAlarmListForEdit> responses, int language)
        {
            if (!responses.Any())
            {
                throw new BadRequestException(CommonEnum.RecordNotFound);
            }

            var rootDir = FileSystemHelper.GetPhysicalFolders(FileSystemHelper.CommonFileSetting.PhysicalFolder, FileSystemHelper.ExportFileName);
            var temporaryFileName = $"Alarm_code_{DateTime.Now:yyyyMMddHHmmss}.xlsx";
            var fileName = Path.Combine(rootDir, temporaryFileName);

            dynamic helper;
            helper = new EpPlusExcelHelper<AlarmCode>(language);
            try
            {
                var machineYields = new List<AlarmCode>();
                var index = 1;
                foreach (var yield in responses)
                {
                    var machineYield = new AlarmCode
                    {
                        No = index,
                        machine_location=yield.machine_location,
                        machine_code = yield.machine_code,
                        machine_type = yield.machine_type,
                        fault_code = yield.fault_code,
                        error_msg = yield.error_msg,
                        fault_content = yield.fault_content,
                        fault_reason = yield.fault_reason,
                        fault_solution = yield.fault_solution,
                        alarm_times = yield.alarm_times,
                        isFault = yield.isFault,
                        markTime = yield.markTime,
                        remark = yield.remark,
                    };
                    machineYields.Add(machineYield);
                    index++;
                }

                helper.GenerateExcel(machineYields, fileName);
                return new ObjectResult($"{FileSystemHelper.CommonFileSetting.RequestPath}/{FileSystemHelper.ExportFileName}/{temporaryFileName}");
            }
            catch (Exception e)
            {
                Logger.WriteLineError("ExportBarChart failed, error: " + e.Message);
                throw new BadRequestException(RequestEnum.ExportFailed);
            }
            finally
            {
                helper.Dispose();
            }
            throw new BadRequestException(RequestEnum.ExportFailed);
        }
        /// <summary>
        /// 长龄1.5
        /// </summary>
        /// <param name="responses"></param>
        /// <param name="language"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult ExportMachineAlarmList(List<ResponseGetMachineAlarmList> responses, int language)
        {
            if (!responses.Any())
            {
                throw new BadRequestException(CommonEnum.RecordNotFound);
            }

            var rootDir = FileSystemHelper.GetPhysicalFolders(FileSystemHelper.CommonFileSetting.PhysicalFolder, FileSystemHelper.ExportFileName);
            var temporaryFileName = $"MachineAlarm_{DateTime.Now:yyyyMMddHHmmss}.xlsx";
            var fileName = Path.Combine(rootDir, temporaryFileName);

            dynamic helper;
            helper = new EpPlusExcelHelper<MachineAlarm>(language);
            try
            {
                var machineYields = new List<MachineAlarm>();
                var index = 1;
                foreach (var yield in responses)
                {
                    var machineYield = new MachineAlarm
                    {
                        No = index,
                        MachineCode=yield.MachineCode,
                        Code = yield.Code,
                        Message = yield.Message,
                        FaultContent = yield.FaultContent,
                        FaultReason = yield.FaultReason,
                        FaultSolution = yield.FaultSolution,
                        StartTime = yield.StartTime,
                        EndTime = yield.EndTime,
                        Duration = yield.Duration,
                        Active = yield.Active==0?"已关闭":"报警中",
                        IsFault = yield.IsFault==1?"是":"否"
                    };
                    machineYields.Add(machineYield);
                    index++;
                }

                helper.GenerateExcel(machineYields, fileName);
                return new ObjectResult($"{FileSystemHelper.CommonFileSetting.RequestPath}/{FileSystemHelper.ExportFileName}/{temporaryFileName}");
            }
            catch (Exception e)
            {
                Logger.WriteLineError("ExportBarChart failed, error: " + e.Message);
                throw new BadRequestException(RequestEnum.ExportFailed);
            }
            finally
            {
                helper.Dispose();
            }
            throw new BadRequestException(RequestEnum.ExportFailed);
        }

        /// <summary>
        /// 长龄1.5
        /// </summary>
        /// <param name="responses"></param>
        /// <param name="language"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult ExportAbnormalList(List<ResponseGetAbnormalList> responses, int language)
        {
            if (!responses.Any())
            {
                throw new BadRequestException(CommonEnum.RecordNotFound);
            }

            var rootDir = FileSystemHelper.GetPhysicalFolders(FileSystemHelper.CommonFileSetting.PhysicalFolder, FileSystemHelper.ExportFileName);
            var temporaryFileName = $"Abnormal_{DateTime.Now:yyyyMMddHHmmss}.xlsx";
            var fileName = Path.Combine(rootDir, temporaryFileName);

            dynamic helper;
            helper = new EpPlusExcelHelper<Alarm>(language);
            try
            {
                var machineYields = new List<Alarm>();
                var index = 1;
                foreach (var yield in responses)
                {
                    var time = GetTimeBySecond(yield.time_span.ToInt());
                    var machineYield = new Alarm
                    {
                        No = index,
                        stas = yield.stas,
                        start_time= UnixTimeHelper.ConvertIntDateTime(yield.start_time),
                        end_time= UnixTimeHelper.ConvertIntDateTime(yield.end_time),
                        time_span= time
                    };

                    if (yield.exception_type == 1)
                    {
                        machineYield.exception_type = "主轴转速";
                    }
                    else if (yield.exception_type == 2)
                    {
                        machineYield.exception_type = "主轴倍率";
                    }
                    else
                    {
                        machineYield.exception_type = "进给倍率";
                    }
                    machineYields.Add(machineYield);
                    index++;
                }
                helper.GenerateExcel(machineYields, fileName);
                return new ObjectResult($"{FileSystemHelper.CommonFileSetting.RequestPath}/{FileSystemHelper.ExportFileName}/{temporaryFileName}");
            }
            catch (Exception e)
            {
                Logger.WriteLineError("ExportBarChart failed, error: " + e.Message);
                throw new BadRequestException(RequestEnum.ExportFailed);
            }
            finally
            {
                helper.Dispose();
            }
            throw new BadRequestException(RequestEnum.ExportFailed);
        }
        private static string GetTimeBySecond(int totalSecond)
        {
            var timeStr = "";
            if (totalSecond == 0)
            {
                timeStr = "0";
            }

            var day = totalSecond / 86400;
            if (day > 0)
            {
                timeStr += day + "天";
            }

            var hour = (totalSecond % 86400) / 3600;
            if (hour > 0)
            {
                timeStr += hour + "小时";
            }

            var min = (((totalSecond % 86400) % 3600) / 60);
            if (min > 0)
            {
                timeStr += min + "分钟";
            }

            var sec = ((totalSecond % 86400) % 3600) % 60;
            if (sec > 0)
            {
                timeStr += sec + "秒";
            }

            return timeStr;
        }

        /// <summary>
        /// 长龄1.5
        /// </summary>
        /// <param name="responses"></param>
        /// <param name="language"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult ExportEfficiencyAnalysisInfoFour(List<RequestEff> responses, int language)
        {
            if (!responses.Any())
            {
                throw new BadRequestException(CommonEnum.RecordNotFound);
            }

            var rootDir = FileSystemHelper.GetPhysicalFolders(FileSystemHelper.CommonFileSetting.PhysicalFolder, FileSystemHelper.ExportFileName);
            var temporaryFileName = $"EfficiencyAnalysisInfo_{DateTime.Now:yyyyMMddHHmmss}.xlsx";
            var fileName = Path.Combine(rootDir, temporaryFileName);

            dynamic helper;
            var count = responses.FirstOrDefault().eff.Count();
            dynamic machineYields;
            switch (count)
            {
                case 28:
                    helper = new EpPlusExcelHelper<DateTemplate>(language);
                    machineYields = new List<DateTemplate>();
                    break;
                case 29:
                    helper = new EpPlusExcelHelper<DateTemplate2>(language);
                    machineYields = new List<DateTemplate2>();
                    break;
                case 30:
                    helper = new EpPlusExcelHelper<DateTemplate3>(language);
                    machineYields = new List<DateTemplate3>();
                    break;
                default:
                    helper = new EpPlusExcelHelper<DateTemplate4>(language);
                    machineYields = new List<DateTemplate4>();
                    break;
            }
            
            try
            {
                
                var index = 1;
                foreach (var yield in responses)
                {
                    dynamic machineYield;
                    var productList = new List<string>();
                    switch (count)
                    {
                        case 28:
                            foreach (var item in yield.eff)
                            {
                                productList.Add(item.productivity.ToString());
                            }
                            machineYield = new DateTemplate
                            {
                                No = index,
                                title= yield.eff.FirstOrDefault().title,
                                productivity1 = productList[0]+"%",
                                productivity2 = productList[1] + "%",
                                productivity3 = productList[2] + "%",
                                productivity4 = productList[3] + "%",
                                productivity5 = productList[4] + "%",
                                productivity6 = productList[5] + "%",
                                productivity7 = productList[6] + "%",
                                productivity8 = productList[7] + "%",
                                productivity9 = productList[8] + "%",
                                productivity10 = productList[9] + "%",
                                productivity11 = productList[10] + "%",
                                productivity12 = productList[11] + "%",
                                productivity13 = productList[12] + "%",
                                productivity14 = productList[13] + "%",
                                productivity15 = productList[14] + "%",
                                productivity16 = productList[15] + "%",
                                productivity17 = productList[16] + "%",
                                productivity18 = productList[17] + "%",
                                productivity19 = productList[18] + "%",
                                productivity20 = productList[19] + "%",
                                productivity21 = productList[20] + "%",
                                productivity22 = productList[21] + "%",
                                productivity23 = productList[22] + "%",
                                productivity24 = productList[23] + "%",
                                productivity25 = productList[24] + "%",
                                productivity26 = productList[25] + "%",
                                productivity27 = productList[26] + "%",
                                productivity28 = productList[27] + "%"
                            };
                            machineYields.Add(machineYield);
                            index++;
                            break;
                        case 29:
                            foreach (var item in yield.eff)
                            {
                                productList.Add(item.productivity.ToString());
                            }
                            machineYield = new DateTemplate2
                            {
                                No = index,
                                title = yield.eff.FirstOrDefault().title,
                                productivity1 = productList[0] + "%",
                                productivity2 = productList[1] + "%",
                                productivity3 = productList[2] + "%",
                                productivity4 = productList[3] + "%",
                                productivity5 = productList[4] + "%",
                                productivity6 = productList[5] + "%",
                                productivity7 = productList[6] + "%",
                                productivity8 = productList[7] + "%",
                                productivity9 = productList[8] + "%",
                                productivity10 = productList[9] + "%",
                                productivity11 = productList[10] + "%",
                                productivity12 = productList[11] + "%",
                                productivity13 = productList[12] + "%",
                                productivity14 = productList[13] + "%",
                                productivity15 = productList[14] + "%",
                                productivity16 = productList[15] + "%",
                                productivity17 = productList[16] + "%",
                                productivity18 = productList[17] + "%",
                                productivity19 = productList[18] + "%",
                                productivity20 = productList[19] + "%",
                                productivity21 = productList[20] + "%",
                                productivity22 = productList[21] + "%",
                                productivity23 = productList[22] + "%",
                                productivity24 = productList[23] + "%",
                                productivity25 = productList[24] + "%",
                                productivity26 = productList[25] + "%",
                                productivity27 = productList[26] + "%",
                                productivity28 = productList[27] + "%",
                                productivity29 = productList[28] + "%"
                            };
                            machineYields.Add(machineYield);
                            index++;
                            break;
                        case 30:
                            foreach (var item in yield.eff)
                            {
                                productList.Add(item.productivity.ToString());
                            }
                            machineYield = new DateTemplate3
                            {
                                No = index,
                                title = yield.eff.FirstOrDefault().title,
                                productivity1 = productList[0] + "%",
                                productivity2 = productList[1] + "%",
                                productivity3 = productList[2] + "%",
                                productivity4 = productList[3] + "%",
                                productivity5 = productList[4] + "%",
                                productivity6 = productList[5] + "%",
                                productivity7 = productList[6] + "%",
                                productivity8 = productList[7] + "%",
                                productivity9 = productList[8] + "%",
                                productivity10 = productList[9] + "%",
                                productivity11 = productList[10] + "%",
                                productivity12 = productList[11] + "%",
                                productivity13 = productList[12] + "%",
                                productivity14 = productList[13] + "%",
                                productivity15 = productList[14] + "%",
                                productivity16 = productList[15] + "%",
                                productivity17 = productList[16] + "%",
                                productivity18 = productList[17] + "%",
                                productivity19 = productList[18] + "%",
                                productivity20 = productList[19] + "%",
                                productivity21 = productList[20] + "%",
                                productivity22 = productList[21] + "%",
                                productivity23 = productList[22] + "%",
                                productivity24 = productList[23] + "%",
                                productivity25 = productList[24] + "%",
                                productivity26 = productList[25] + "%",
                                productivity27 = productList[26] + "%",
                                productivity28 = productList[27] + "%",
                                productivity29 = productList[28] + "%",
                                productivity30 = productList[29] + "%"
                            };
                            machineYields.Add(machineYield);
                            index++;
                            break;
                        default:
                            foreach (var item in yield.eff)
                            {
                                productList.Add(item.productivity.ToString());
                            }
                            machineYield = new DateTemplate4
                            {
                                No = index,
                                title = yield.eff.FirstOrDefault().title,
                                productivity1 = productList[0] + "%",
                                productivity2 = productList[1] + "%",
                                productivity3 = productList[2] + "%",
                                productivity4 = productList[3] + "%",
                                productivity5 = productList[4] + "%",
                                productivity6 = productList[5] + "%",
                                productivity7 = productList[6] + "%",
                                productivity8 = productList[7] + "%",
                                productivity9 = productList[8] + "%",
                                productivity10 = productList[9] + "%",
                                productivity11 = productList[10] + "%",
                                productivity12 = productList[11] + "%",
                                productivity13 = productList[12] + "%",
                                productivity14 = productList[13] + "%",
                                productivity15 = productList[14] + "%",
                                productivity16 = productList[15] + "%",
                                productivity17 = productList[16] + "%",
                                productivity18 = productList[17] + "%",
                                productivity19 = productList[18] + "%",
                                productivity20 = productList[19] + "%",
                                productivity21 = productList[20] + "%",
                                productivity22 = productList[21] + "%",
                                productivity23 = productList[22] + "%",
                                productivity24 = productList[23] + "%",
                                productivity25 = productList[24] + "%",
                                productivity26 = productList[25] + "%",
                                productivity27 = productList[26] + "%",
                                productivity28 = productList[27] + "%",
                                productivity29 = productList[28] + "%",
                                productivity30 = productList[29] + "%",
                                productivity31 = productList[30] + "%",
                            };
                            machineYields.Add(machineYield);
                            index++;
                            break;
                    }
                }
                helper.GenerateExcel(machineYields, fileName);
                return new ObjectResult($"{FileSystemHelper.CommonFileSetting.RequestPath}/{FileSystemHelper.ExportFileName}/{temporaryFileName}");
            }
            catch (Exception e)
            {
                Logger.WriteLineError("ExportBarChart failed, error: " + e.Message);
                throw new BadRequestException(RequestEnum.ExportFailed);
            }
            finally
            {
                helper.Dispose();
            }
            throw new BadRequestException(RequestEnum.ExportFailed);
        }

        /// <summary>
        /// 长岭绩效导出
        /// </summary>
        /// <param name="responses"></param>
        /// <param name="language"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult Exportjx(List<ResponseAchieveTotal> responses, int language)
        {
            if (!responses.Any())
            {
                throw new BadRequestException(CommonEnum.RecordNotFound);
            }

            var fileSetting = Config<FileSettings>.Get();
            if (fileSetting == null)
            {
                throw new BadRequestException(CommonEnum.GetCommCfgFailed);
            }

            var rootDir = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, fileSetting.FileSetting.PhysicalFolder, "ExportFiles");
            if (!Directory.Exists(rootDir))
            {
                Directory.CreateDirectory(rootDir);
            }
            var temporaryFileName = $"绩效统计_{DateTime.Now:yyyyMMddHHmmss}.xlsx";
            var fileName = Path.Combine(rootDir, temporaryFileName);

            dynamic helper;
            helper = new EpPlusExcelHelper<AchievementList>(language);
            try
            {
                var machineYields = new List<AchievementList>();
                var index = 1;
                foreach (var yield in responses)
                {
                    var machineYield = new AchievementList
                    {
                        No = index,
                        work_code = yield.work_code,
                        name = yield.name,
                        shift = yield.shift,
                        section = yield.section,
                        usergroup = yield.usergroup,
                        workhour = yield.workhour.ToString(),
                        affecthour = yield.affecthour.ToString(),
                        avemachine = yield.avemachine.ToString(),
                        workeffect = yield.workeffect.ToString(),
                    };


                    machineYields.Add(machineYield);
                    index++;
                }
                helper.GenerateExcel(machineYields, fileName);
                return new ObjectResult(
                    $"{fileSetting.FileSetting.RequestPath}/ExportFiles/{temporaryFileName}");
            }
            catch (Exception e)
            {
                Logger.WriteLineError("ExportBarChart failed, error: " + e.Message);
                throw new BadRequestException(RequestEnum.ExportFailed);
            }
            finally
            {
                helper.Dispose();
            }
            throw new BadRequestException(RequestEnum.ExportFailed);
        }
    }
}