﻿using System;
using System.Linq;
using Microsoft.AspNetCore.Mvc;
using Siger.ApiCommon.Result;
using Siger.Middlelayer.CncRepository.Entities;
using Siger.Middlelayer.CncRepository.Repositories.Interface;
using Siger.Middlelayer.CncRepository.Request;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Repository;

namespace Siger.ApiCNC.Controllers
{
    public class PlanChangeController : BaseController
    {
        private readonly IUnitOfWork _unitOfWork;
        private readonly ISigerProjectPlanChangeRepository _changeRepository;
        private readonly IProductPlanRepository _planRepository;
        public PlanChangeController(IUnitOfWork unitOfWork, ISigerProjectPlanChangeRepository changeRepository, IProductPlanRepository planRepository)
        {
            _unitOfWork = unitOfWork;
            _changeRepository = changeRepository;
            _planRepository = planRepository;
        }

        [HttpGet]
        public IActionResult GetPlanChangeList(string code, string product_name, string startTime, string endTime, int page, int pagesize)
        {
            var data = _changeRepository.GetPlanChanges(code, product_name, startTime, endTime, ProjectId, page,
                pagesize);

            return new PagedObjectResult(data.Data, data.Total, page, pagesize);
        }

        [HttpPost]
        public IActionResult AddChangeRecord([FromBody]RequestAddChangeRecord request)
        {
            if (request.plan_id == 0)
            {
                throw new BadRequestException(RequestEnum.ParameterError);
            }
            if (string.IsNullOrWhiteSpace(request.new_code))
            {
                throw new BadRequestException(RequestEnum.BillCodeNotNull);
            }

            var record = new siger_project_product_plan_change
            {
                plan_id = request.plan_id,
                approval_status = 0,
                create_time = DateTime.Now,
                new_code = request.new_code,
                operator_mid = UserId,
                project_id = ProjectId
            };
            _changeRepository.Insert(record);
            if (_unitOfWork.Commit() > 0)
            {
                return new ObjectResult(CommonEnum.Succefull);
            }
            throw new BadRequestException(CommonEnum.Fail);
        }

        [HttpPost]
        public IActionResult ApprovalRecord(string ids, int state)
        {
            if (string.IsNullOrWhiteSpace(ids))
            {
                throw new BadRequestException(RequestEnum.ParameterError);
            }

            foreach (var id in ids.Split(',').ToList())
            {
                var record = _changeRepository.Get(q => q.id == id.ToInt() && q.status == (int)RowState.Valid && q.project_id == ProjectId);
                if (record == null)
                {
                    throw new BadRequestException(CommonEnum.RecordNotFound);
                }

                var plan = _planRepository.Get(q => q.id == record.plan_id && q.projectid == ProjectId);
                if (plan == null)
                {
                    throw new BadRequestException(CommonEnum.RecordNotFound);
                }
                record.approval_status = state;
                _changeRepository.Update(record);

                if (state == 1)
                {
                    plan.ordernumber = record.new_code;
                    _planRepository.Update(plan);
                }
            }

            if (_unitOfWork.Commit() > 0)
            {
                return new ObjectResult(CommonEnum.Succefull);
            }
            throw new BadRequestException(CommonEnum.Fail);
        }
    }
}