﻿using System.Collections.Generic;

namespace Siger.ApiCNC.Result
{
    public class AbnormalDetailResult : CncResultBase
    {
        public int machine_nums { get; set; }

        public AbnormalDetail data { get; set; }

        public AbnormalDetailResult()
        {
            data = new AbnormalDetail();
        }
    }

    public class AbnormalDetail
    {
        public Dictionary<int, object> ProductionParameterLis { get; set; }

        public int exceptionCount { get; set; }

        public int normalCount { get; set; }

        public List<NameValue> pieChart { get; set; }

        public AbnormalDetail()
        {
            ProductionParameterLis = new Dictionary<int, object>();
            pieChart = new List<NameValue>();
        }
    }

    public class NameValue
    {
        public string name { get; set; }

        public double value { get; set; } = 0;
    }

    public class AbnormalDetailInfo
    {
        public string StartTime { get; set; }

        public string TimeSpan { get; set; }

        public string downlimit { get; set; }

        public string endOf { get; set; }

        public int exception_type { get; set; }

        public int row_count { get; set; }

        public int section_id { get; set; }

        public string section_name { get; set; }

        public string station_name { get; set; }

        public string uplimit { get; set; }

        public int values { get; set; }
    }
}
