﻿using System;
using System.Collections.Generic;
using System.Linq;
using Siger.Middlelayer.Share.Models;

namespace Siger.ApiCNC.Result
{
    public class MachineRunningStateResult : CncResultBase
    {
        public string iszy { get; set; }
        /// <summary>
        /// 灯的状态
        /// </summary>
        public int lampStatus { get; set; }
        /// <summary>
        /// 设备布局图
        /// </summary>
        public string layout { get; set; }

        public object zy_data { get; set; }

        public Dictionary<int, object> listAll { get; set; }

        public LastData last_data { get; set; }

        public MachineRunningStateResult()
        {
            listAll = new Dictionary<int, object>();
            last_data = new LastData();
        }
    }

    public class MachineRunningResult
    {
        public int shutdown { get; set; } = 0;

        public int running { get; set; } = 0;

        public int debugging { get; set; } = 0;

        public int idle { get; set; } = 0;

        public int fault { get; set; } = 0;
    }

    public class MachineDetailState
    {
        public string location { get; set; }

        public string machineCode { get; set; }
        public string machineName { get; set; }

        public string state { get; set; }

        public string programNo { get; set; }

        /// <summary>
        /// 主轴转速
        /// </summary>
        public double spindleSpeed { get; set; }

        /// <summary>
        /// 转速倍率
        /// </summary>
        public double spindleRatio { get; set; }

        /// <summary>
        /// 进给倍率
        /// </summary>
        public double feedRatio { get; set; }

        /// <summary>
        /// 压铸机压力
        /// </summary>
        public double pressure { get; set; } = 0;

        /// <summary>
        /// 熔炉温度
        /// </summary>
        public double temperature { get; set; } = 0;
    }
}
