﻿using System;
using Microsoft.Extensions.DependencyInjection;
using Siger.Middlelayer.Log;
namespace Siger.ApiCommon.Utilities
{
    public static class Cors
    {
        /// <summary>
        /// 子服务跨域支持
        /// </summary>
        /// <param name="services"></param>
        public static void AddCors(IServiceCollection services)
        {
            try
            {
                services.AddCors(o => o.AddPolicy("Cors", builder => builder.AllowAnyOrigin()
                    .AllowAnyHeader()
                    .AllowAnyMethod()
                    .AllowCredentials()
                ));
            }
            catch (Exception e)
            {
                Logger.WriteLineError(e.ToString());
            }
        }
    }
}
