﻿using System.Linq;
using Microsoft.AspNetCore.Mvc;
using Siger.ApiCommon.Exceptions;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Repositories.Interface;
using Siger.Middlelayer.Repository.Request;
using Siger.Middlelayer.Repository.Response;

namespace Siger.ApiConfig.Controller
{
    public class FieldController : BaseController
    {
        private readonly ISigerProjectUserGroupRepository _projectUserGroupRepository;
        public FieldController(ISigerProjectUserGroupRepository projectUserGroupRepository)
        {
            _projectUserGroupRepository = projectUserGroupRepository;
        }

        [HttpPost]
        public IActionResult AddField([FromBody]RequestAddUserGroupKeys request)
        {
            var fileds = request.fieldarr.Where(q => !string.IsNullOrWhiteSpace(q.fieldname)).ToList();
            if (!fileds.Any())
            {
                throw new BadRequestException(RequestEnum.FieleNameIsEmpty);
            }
            var result =
                _projectUserGroupRepository.AddUserGroupKeys(request.usergroupid, ProjectId, fileds);
            if (result == AddUserGroupKeysEnum.KeyHasExist)
            {
                throw new BadRequestException(RequestEnum.UserGroupKeyValueHasExist);
            }

            if (result == AddUserGroupKeysEnum.Failed)
            {
                throw new BadRequestException(CommonEnum.SystemExcetion);
            }
            return new ObjectResult(CommonEnum.Succefull);
        }
    }
}