﻿using System.Collections.Generic;
using Microsoft.AspNetCore.Mvc;
using Siger.ApiCommon.Exceptions;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Repositories.Interface;
using Siger.Middlelayer.Repository.Response;

namespace Siger.ApiConfig.Controller
{
    public class LocationController : BaseController
    {
        private readonly ISigerLocationProvinceRepository _provinceRepository;
        private readonly ISigerLocationCityRepository _cityRepository;
        private readonly ISigerLocationCountyRepository _countyRepository;
        public LocationController(ISigerLocationProvinceRepository provinceRepository, ISigerLocationCityRepository cityRepository,
            ISigerLocationCountyRepository countyRepository)
        {
            _provinceRepository = provinceRepository;
            _cityRepository = cityRepository;
            _countyRepository = countyRepository;
        }

        [HttpGet]
        public IActionResult GetProvinces()
        {
            var response = new List<ResponseNameCode>();

            var provinces = _provinceRepository.GetList(q => q.status == (int)RowState.Valid);
            foreach (var province in provinces)
            {
                response.Add(new ResponseNameCode {code = province.code, name = province.name});
            }

            return new ObjectResult(response);
        }

        [HttpGet]
        public IActionResult GetCities(string province_code)
        {
            if (string.IsNullOrEmpty(province_code))
            {
                throw new BadRequestException(RequestEnum.ProvinceCodeIsEmpty);
            }
            var response = new List<ResponseNameCode>();
            var cities = _cityRepository.GetList(q => q.status == (int)RowState.Valid && q.province_code == province_code);
            foreach (var city in cities)
            {
                response.Add(new ResponseNameCode { code = city.code, name = city.name });
            }

            return new ObjectResult(response);
        }

        [HttpGet]
        public IActionResult GetContries(string city_code)
        {
            if (string.IsNullOrEmpty(city_code))
            {
                throw new BadRequestException(RequestEnum.CityCodeIsEmpty);
            }
            var response = new List<ResponseNameCode>();
            var countries = _countyRepository.GetList(q => q.status == (int)RowState.Valid && q.city_code == city_code);
            foreach (var country in countries)
            {
                response.Add(new ResponseNameCode { code = country.code, name = country.name });
            }

            return new ObjectResult(response);
        }

        [HttpGet]
        public IActionResult GetLocation(string province_code, string city_code)
        {
            var response = new List<ResponseLocation>();
            if (!string.IsNullOrWhiteSpace(province_code))
            {
                var cities = _cityRepository.GetList(q => q.status == (int)RowState.Valid && q.province_code == province_code);
                foreach (var city in cities)
                {
                    response.Add(new ResponseLocation { id = city.id, code = city.code, name = city.name, status = city.status });
                }
            }
            if (!string.IsNullOrWhiteSpace(city_code))
            {
                var countries = _countyRepository.GetList(q => q.status == (int)RowState.Valid && q.city_code == city_code);
                foreach (var country in countries)
                {
                    response.Add(new ResponseLocation { id = country.id, code = country.code, name = country.name, status = country.status });
                }
            }
            else if(string.IsNullOrEmpty(province_code) && string.IsNullOrEmpty(city_code))
            {
                var provinces = _provinceRepository.GetList(q => q.status == (int)RowState.Valid);
                foreach (var province in provinces)
                {
                    response.Add(new ResponseLocation { id = province.id, code = province.code, name = province.name, status = province.status });
                }
            }
            
            return new ObjectResult(response);
        }
    }
}