﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Linq.Expressions;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Logging;
using Siger.ApiCommon.Result;
using Siger.ApiCommon.Utilities;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.AppSettings;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Common.Log;
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Extensions;
using Siger.Middlelayer.Repository.Repositories.Interface;
using Siger.Middlelayer.Repository.Request;
using Siger.Middlelayer.Repository.Response;
using Siger.Middlelayer.Utility.Helpers;

namespace Siger.ApiConfig.Controller
{
    public class MachineNodeController : BaseController
    {
        private readonly IUnitOfWork _unitOfWork;
        private readonly ISigerProjectMachineNodeRepository _machineNodeRepository;

        public MachineNodeController(IUnitOfWork unitOfWork, ISigerProjectMachineNodeRepository machineNodeRepository)
        {
            _unitOfWork = unitOfWork;
            _machineNodeRepository = machineNodeRepository;
        }
        [HttpPost]
        public IActionResult GetNodeData([FromBody]RequestMachineNode req)
        {

            var data = _machineNodeRepository.GetData(req, ProjectId);
            return new PagedObjectResult(data.Data, data.Total);
        }

        [HttpPost]
        public IActionResult AddNodeData([FromBody]RequestMachineNodeData req)
        {
            var model = Mapper<RequestMachineNodeData, siger_project_machine_node>.Map(req);
            var allow = EnumHelper.EnumToList<MachineNodeName>().Where(f => f.EnumValue > 4).Select(s => s.EnumValue).ToList();
            if (!allow.Contains(model.node_name))
            {
                Logger.WriteLineInfo($"节点名称为{model.node_name}无法保存！");
                throw new BadRequestException(CommonEnum.Fail);
            }
            model.node_time = UnixTimeHelper.GetNow(); 
            model.node_operator = UserId;
            model.projectid = ProjectId;
            _machineNodeRepository.Insert(model);
            if (_unitOfWork.Commit() > 0)
            {
                return new ObjectResult(CommonEnum.Succefull);
            }
            throw new BadRequestException(CommonEnum.Fail);
        }

        [HttpPost]
        public IActionResult ModifyNodeData([FromBody]RequestAddMachineNodeData req)
        {
            var model = _machineNodeRepository.Get(f => f.id.Equals(req.id) && f.status == (int)RowState.Valid && f.projectid.Equals(ProjectId));
            if (model == null)
            {
                throw new BadRequestException(CommonEnum.NoData);
            }
            //var allow = EnumHelper.EnumToList<MachineNodeName>().Where(f => f.EnumValue > 4).Select(s => s.EnumValue).ToList();
            //if (!allow.Contains(req.node_name))
            //{
            //    Logger.WriteLineInfo($"节点名称为{model.node_name}无法修改！");
            //    throw new BadRequestException(CommonEnum.Fail);
            //}
            model.node_name = req.node_name;
            model.node_info = req.node_info;
            model.node_cost = req.node_cost;
            model.node_time = UnixTimeHelper.GetNow();
            model.node_operator = UserId;
            _machineNodeRepository.Update(model);
            if (_unitOfWork.Commit() > 0)
            {
                return new ObjectResult(CommonEnum.Succefull);
            }
            throw new BadRequestException(CommonEnum.Fail);
        }
        [HttpGet]
        public IActionResult DeleteNodeData(int id)
        {
            var model = _machineNodeRepository.Get(f => f.id.Equals(id) && f.status == (int)RowState.Valid && f.projectid.Equals(ProjectId));
            var allow = EnumHelper.EnumToList<MachineNodeName>().Where(f => f.EnumValue > 4).Select(s => s.EnumValue).ToList();
            if (!allow.Contains(model.node_name))
            {
                Logger.WriteLineInfo($"节点名称为{model.node_name}无法删除！");
                throw new BadRequestException(CommonEnum.Fail);
            }
            if (model == null)
            {
                return new ObjectResult(CommonEnum.Succefull);
            }
            model.status = (int)RowState.Invalid;
            if (_unitOfWork.Commit() > 0)
            {
                return new ObjectResult(CommonEnum.Succefull);
            }
            throw new BadRequestException(CommonEnum.Fail);
        }
    }
}