﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using Microsoft.AspNetCore.Mvc;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Extensions;
using Siger.Middlelayer.Repository.Repositories.Interface;
using Siger.Middlelayer.Repository.Response;

namespace Siger.ApiConfig.Controller
{
    public class MaterialController : BaseController
    {
        private readonly ISigerTrMaterialsRepository _materials;
        private readonly ISigerProjectProductStructure _projectProductStructure;
        public MaterialController(ISigerTrMaterialsRepository materials, ISigerProjectProductStructure projectProductStructure)
        {
            _materials = materials;
            _projectProductStructure = projectProductStructure;
        }
        /// <summary>
        /// 获取物料信息
        /// </summary>
        /// <param name="pn">物料编号</param>
        /// <param name="name">物料名称</param>
        /// <param name="count">个数</param>
        /// <returns></returns>
        [HttpGet]
        public IActionResult GetMaterialData(string pn, string name, int count)
        {
            Expression<Func<siger_tr_materials, bool>> funcCommon = f =>
                f.projectId.Equals(ProjectId) && f.status != (int)RowState.Invalid;
            Expression<Func<siger_tr_materials, bool>> funcPn = f => true;
            Expression<Func<siger_tr_materials, bool>> funcName = f => true;
            if (!string.IsNullOrWhiteSpace(pn))
            {
                funcPn = f => f.pn.Contains(pn);
            }
            if (!string.IsNullOrWhiteSpace(name))
            {
                funcPn = f => f.name.Contains(name);
            }
            var predicate = funcCommon.And(funcPn).And(funcName);
            var resp = _materials.GetList(predicate);
            if (count != 0)
            {
                resp = resp.Take(count);
            }
            return new ObjectResult(resp);
        }
        /// <summary>
        /// 获取物料信息(详细版)
        /// </summary>
        /// <param name="pn"></param>
        /// <param name="name"></param>
        /// <param name="count"></param>
        /// <param name="exp"></param>
        /// <param name="typeid"></param>
        /// <param name="supplierId"></param>
        /// <returns></returns>
        [HttpGet]
        public IActionResult GetMaterials(string pn, string name, int count, int exp, int typeid, int supplierId)
        {
            var resp = new List<Material>();
            var data = _materials.GetMaterialsData(name, exp, pn, typeid, supplierId, ProjectId, 0, count).Data.ToList();
            foreach (var material in data)
            {
                foreach (var supplier in material.supplierdata)
                {
                    var newResp = material;
                    newResp.supplierdata = null;
                    newResp.supplier_code = supplier.serial_number;
                    newResp.supplier_name = supplier.name;
                    resp.Add(newResp);
                }
            }
            return new ObjectResult(resp);
        }

        [HttpGet]
        public IActionResult GetMaterialList()
        {
            //var data = _materials.GetList(t => t.projectId == ProjectId && t.status == (int)RowState.Valid).Select(t => new
            //{
            //    t.id,
            //    t.name,
            //    t.pn,
            //    t.spec
            //}).OrderBy(q => q.pn).ToList();

            var data = _materials.GetMaterialSuppliers(ProjectId);

            return new ObjectResult(data);
        }
        /// <summary>
        /// 获取产品 物料
        /// </summary>
        /// <param name="productId"></param>
        /// <returns></returns>
        [HttpGet]
        public IActionResult GetMaterialByProcut(int productId)
        {

            var structure = _projectProductStructure.Get(f => f.projectid == ProjectId && f.itemid == productId && f.itemtype == Middlelayer.Common.ModuleEnum.ComboxItem.Product);
            if (structure == null)
                return new ObjectResult(0);

            var data = _materials.GetTrMaterialsByProductId(ProjectId, structure.id).ToList();
            return new ObjectResult(data);
        }


        [HttpGet]
        public IActionResult GetSonMaterialsByProduct(int productid)
        {
            var res = new List<ResponseSonMaterials>();
            var structure = _projectProductStructure.Get(f => f.projectid == ProjectId && f.itemid == productid && f.itemtype == Middlelayer.Common.ModuleEnum.ComboxItem.Product);
            if (structure == null)
            {
                return new ObjectResult(res);
            }

            res = _materials.GetSonMaterialsByProductId(ProjectId, structure.id).ToList();
            return new ObjectResult(res);
        }

        [HttpGet]
        public IActionResult GetSonMaterialNamesByProduct(int productid)
        {
            var res = new List<ResponseSonMaterials>();
            var structure = _projectProductStructure.Get(f => f.projectid == ProjectId && f.itemid == productid && f.itemtype == Middlelayer.Common.ModuleEnum.ComboxItem.Product);
            if (structure == null)
            {
                return new ObjectResult(res);
            }

            res = _materials.GetSonMaterialsByProductId(ProjectId, structure.id).GroupBy(t => t.name).
                Select(t => t.FirstOrDefault()).ToList();
            return new ObjectResult(res);
        }

        [HttpGet]
        public IActionResult GetSupplierByMaterial(int materialid)
        {
            var res = _materials.GetSuppliersByMaterialId(materialid, ProjectId).ToList();
            return new ObjectResult(res);
        }
    }
}