﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Siger.ApiCommon.Result;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Repositories.Interface;
using Siger.Middlelayer.Repository.Request;

namespace Siger.ApiConfig.Controller
{
    public class RestTypeController : BaseController
    {
        private readonly IUnitOfWork _unitOfWork;
        private readonly ISigerProjectRestTypeRepository _restTypeRepository;
        private readonly ISigerProjectUserRepository _userRepository;
        public RestTypeController(IUnitOfWork unitOfWork, ISigerProjectRestTypeRepository restTypeRepository, ISigerProjectUserRepository userRepository)
        {
            _unitOfWork = unitOfWork;
            _restTypeRepository = restTypeRepository;
            _userRepository = userRepository;
        }
        /// <summary>
        /// 休息类型管理 增
        /// </summary>
        /// <param name="ret"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult Add([FromBody] RequestRestType ret)
        {
            if (ret != null)
            {
                var result = new siger_project_rest_type()
                {
                    name = ret.name,
                    range = ret.range,
                    startTime = ret.startTime,
                    endTime = ret.endTime,
                    addTime = DateTime.Now,
                    uid = UserId.ToString(),
                    projectid = ProjectId
                };
                _restTypeRepository.Insert(result);
                if (_unitOfWork.Commit() > 0)
                {
                    return new ObjectResult(CommonEnum.Succefull);
                }
                throw new BadRequestException(CommonEnum.Fail);
            }
            throw new BadRequestException(CommonEnum.Fail);
        }

        /// <summary>
        /// 休息类型管理 删
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        [HttpGet]
        public IActionResult Delete(int id)
        {
            var rest = _restTypeRepository.Get(q => q.id >= id && q.projectid == ProjectId && q.status == (int)RowState.Valid);
            if (rest != null)
            {
                rest.status = (int)RowState.Invalid;
                _restTypeRepository.Update(rest);
            }
            if (_unitOfWork.Commit() > 0)
            {
                return new ObjectResult(CommonEnum.Succefull);
            }
            throw new BadRequestException(CommonEnum.Fail);
        }

        /// <summary>
        /// 休息类型管理 改
        /// </summary>
        /// <param name="ret"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult Update([FromBody] RequestRestTypes ret)
        {
            if (ret != null)
            {
                var rest = _restTypeRepository.Get(q => q.id >= ret.id && q.projectid == ProjectId && q.status == (int)RowState.Valid);
                if (rest != null)
                {
                    rest.name = ret.name;
                    rest.range = ret.range;
                    rest.startTime = ret.startTime;
                    rest.endTime = ret.endTime;
                    _restTypeRepository.Update(rest);
                }
                if (_unitOfWork.Commit() > 0)
                {
                    return new ObjectResult(CommonEnum.Succefull);
                }
                throw new BadRequestException(CommonEnum.Fail);
            }
            throw new BadRequestException(CommonEnum.Fail);
        }

        /// <summary>
        /// 休息类型管理 查
        /// </summary>
        /// <param name="page"></param>
        /// <param name="pageSige"></param>
        /// <returns></returns>
        [HttpGet]
        public IActionResult Select(int page, int pageSige)
        {
            var result = _restTypeRepository.GetRestList(page, pageSige, ProjectId);
            foreach (var item in result.Data)
            {
                var users = _userRepository.Get(q => q.mid.ToString() == item.uid && q.status == (int)RowState.Valid && q.projectid == ProjectId);
                if (users != null)
                {
                    item.uid = users.name;
                }
            }
            return new PagedObjectResult(result.Data, result.Total, page, pageSige);
        }

        /// <summary>
        /// 获取所有的休息类型
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public IActionResult GetAllRestType()
        {
            var list = new List<RequestAllRestType>();
            var result = _restTypeRepository.GetList(q => q.status == (int)RowState.Valid && q.projectid == ProjectId).ToList();
            foreach (var item in result)
            {
                var type = new RequestAllRestType()
                {
                    id = item.id,
                    name = item.name
                };
                list.Add(type);
            }
            return new ObjectResult(list);
        }
    }
}
