﻿using System;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Siger.ApiCommon.Exceptions;
using Siger.ApiCommon.Filters;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Log;
using Siger.Middlelayer.Redis;

namespace Siger.ApiConfig.Controller
{
    [Route("config/[controller]/[action]")]
    [EnableCors("Cors")]
    [NoTokenValidateFilter]
    public class TokenController : ControllerBase
    {
        [HttpGet]
        public IActionResult Get()
        {
            try
            {
                var token = TokenHelper.Generate();
                RedisCache.Instance.AddToken(token.Value, token.Key);
                return new ObjectResult(token.Value);
            }
            catch (Exception e)
            {
                Logger.WriteLineError(e.Message);
                throw new BadRequestException(CommonEnum.Fail);
            }
        }
    }
}
