﻿using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Siger.Middlelayer.Log;
using Siger.ApiCommon.Filters;
using Siger.ApiCommon.Utilities;
using Siger.ApiDNC.Tasks;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.DncRepository;
using Siger.Middlelayer.Redis;
using Microsoft.Extensions.Hosting;
using Newtonsoft.Json;
using Newtonsoft.Json.Serialization;
using Newtonsoft.Json.Converters;
using Microsoft.AspNetCore.Http.Features;
using Siger.Middlelayer.Common.Configuration;

namespace Siger.ApiDNC
{
    public class Startup
    {
        public Startup(IConfiguration configuration)
        {
            Configuration = configuration;
        }
        private string _corsKeyName = "Cors";
        public IConfiguration Configuration { get; }
        // This method gets called by the runtime. Use this method to add services to the container.
        public void ConfigureServices(IServiceCollection services)
        {
            services.AddCors(options => {
                options.AddPolicy(_corsKeyName, builder => builder.AllowAnyOrigin()
                .AllowAnyHeader().AllowAnyMethod());
                //.WithMethods("GET", "POST", "HEAD", "PUT", "DELETE", "OPTIONS")) ;
            });
            services.AddMvc(option => option.EnableEndpointRouting = false).SetCompatibilityVersion(CompatibilityVersion.Version_3_0);
            services.AddControllers().AddNewtonsoftJson(option => {
                option.SerializerSettings.ContractResolver = new CamelCasePropertyNamesContractResolver();
                option.SerializerSettings.Converters.Add(new IsoDateTimeConverter() { DateTimeFormat = "yyyy-MM-dd HH:mm:ss" });
            });
         
            services.AddMvc(options =>
            {
                options.Filters.Add<ModelValidateFilter>();
                options.Filters.Add<ApiExceptionFilter>();
                options.Filters.Add<ResultFilter>();
                options.Filters.Add<TokenValidateFilter>();
            });
            DncRepositoryFactory.Instance.Initialization(services);

            Logger.RegisterLogEngine(Module.Dnc);
            Swagger.AddSwagger(services, Module.Dnc);
            services.Configure<FormOptions>(x =>
            {
                x.ValueLengthLimit = int.MaxValue;
                x.MultipartBodyLengthLimit = int.MaxValue; // In case of multipart
            });
            var startTask = ConfigManager.GetValue("Task", "Start", 0);
            if (startTask == 1)
            {
                Scheduler.StartUp();
            }
        }

        // This method gets called by the runtime. Use this method to configure the HTTP request pipeline.
        public void Configure(IApplicationBuilder app, IWebHostEnvironment env, IHostApplicationLifetime lifetime)
        {
            if (env.IsDevelopment())
            {
                app.UseDeveloperExceptionPage();
            }
            app.UseCors(_corsKeyName);
            app.RegisterSwagger(Module.Dnc);
            app.UseMvc();
            app.RegisterDownSetting();
            app.RegisterConsul(Module.Dnc, lifetime);
            lifetime.ApplicationStopped.Register(RedisCache.Instance.Dispose);
        }

    }
    
}
