﻿using System.Collections.Generic;

namespace Siger.ApiDashboard.Result
{
    public class TpmMachineRepairResult
    {
        public List<MachineRepairStatusModel> MachineRepairStatus { get; set; } = new List<MachineRepairStatusModel>();
    }

    public class MachineRepairStatusModel
    {
        public string location { get; set; }

        public int status { get; set; }

        public int repair_count { get; set; }

        public string executor { get; set; }

        public int downtime { get; set; }
    }


    public class MachineLine
    {
        public string Name { get; set; }

        public int MachineId { get; set; }

        public string Location { get; set; }

        public int IsEnabled { get; set; }

        public int SectionId { get; set; }
    }

    public class ResponseMachineState
    {
        public int run { get; set; }

        public int debug { get; set; }

        public int free { get; set; }

        public int fault { get; set; }

        public int shutdown { get; set; }

        public List<MachineLineLocation> machinelocations { get; set; } = new List<MachineLineLocation>();
    }

    public class MachineLineLocation
    {
        public string location { get; set; }

        public List<MachineLineState> machinestates { get; set; } = new List<MachineLineState>();
    }

    public class MachineLineState
    {
        public int machineid { get; set; }

        public string name { get; set; }

        public string shortname { get; set; }

        public int status { get; set; }

        public int sensorstate { get; set; }

        public int maintenancestate { get; set; }

        public string machinetype { get; set; }

        public string parent_machinetype { get; set; }
    }

    public class MachineIdLineState
    {
        public int MachineId { get; set; }

        //0 关机 1 运行 2 调试 3 空闲 4 故障
        public int State { get; set; }
    }

    public class RequestMachineLineState
    {
        public int typeid { get; set; }
        public List<int> sections { get; set; } = new List<int>();
    }

    public class ResponseMachineStateDetail
    {
        public List<MachineFile> machinefiles { get; set; } = new List<MachineFile>();

        public int machineid { get; set; }

        public string machinename { get; set; }

        public string location { get; set; }

        public int status { get; set; }

        public int repairstate { get; set; }

        public int sensorstate { get; set; }

        public int maintainstate { get; set; }


        //设备详情
        public string description { get; set; }
        public string code { get; set; }
        public string model { get; set; }
        public string factory { get; set; }
        public string factory_code { get; set; }
        public string made_date { get; set; }
        public int time { get; set; }
        public int brand { get; set; }
        /// <summary>
        /// 1->自用；2->出租；3->出借；4->其他在用；5->停用；6->闲置；7->报废 ；8->盘点中 （当前盘点时的状态）
        /// </summary>
        public int current_status { get; set; }
        public string image { get; set; }
        public string ip { get; set; }
        public string savedaycomment { get; set; }
        public string savedays { get; set; }
        public int sorting { get; set; }
        public int typeid { get; set; }
        public string typetitle { get; set; }
        public string current { get; set; }

        /// <summary>
        /// Machine Name
        /// </summary>
        public string machine_name { get; set; } = string.Empty;

        /// <summary>
        /// 测试应用产品
        /// </summary>
        public string typical_application { get; set; } = string.Empty;

        /// <summary>
        /// 尺寸-内径
        /// </summary>
        public string inside_diameter { get; set; } = string.Empty;

        /// <summary>
        /// 尺寸-外径
        /// </summary>
        public string outside_diameter { get; set; } = string.Empty;

        /// <summary>
        /// 径向载荷
        /// </summary>
        public string radial_load { get; set; } = string.Empty;

        /// <summary>
        /// 轴向载荷
        /// </summary>
        public string axial_load { get; set; } = string.Empty;

        /// <summary>
        /// 压力
        /// </summary>
        public string pressure { get; set; } = string.Empty;

        /// <summary>
        /// 转速
        /// </summary>
        public string speed { get; set; } = string.Empty;

        /// <summary>
        /// 温度
        /// </summary>
        public string temperature { get; set; } = string.Empty;

        /// <summary>
        /// 转向
        /// </summary>
        public string rotation { get; set; } = string.Empty;

        /// <summary>
        /// 样本润滑
        /// </summary>
        public string sample_lubrication { get; set; } = string.Empty;

        /// <summary>
        /// 设备用油-润滑
        /// </summary>
        public string oil_lubrication { get; set; } = string.Empty;

        /// <summary>
        /// 设备用油-液压
        /// </summary>
        public string oil_hydraulic { get; set; } = string.Empty;

        /// <summary>
        /// 信号采集
        /// </summary>
        public string signal_monitor { get; set; } = string.Empty;

        /// <summary>
        /// 测试工位
        /// </summary>
        public string position { get; set; } = string.Empty;

        /// <summary>
        /// 设备尺寸
        /// </summary>
        public string machine_size { get; set; } = string.Empty;

        /// <summary>
        /// 设备简称
        /// </summary>
        public string machine_shortname { get; set; } = string.Empty;

        /// <summary>
        /// 负责人
        /// </summary>
        public string responsor { get; set; } = string.Empty;
    }

    public class MachineFile
    {
        public string filename { get; set; }

        public string fileurl { get; set; }

        public int id { get; set; }

        public string uploadtime { get; set; }
    }


    public class MachineRepairs
    {
        public int page { get; set; }

        public int pagesize { get; set; }

        public int total { get; set; }

        public List<MachineRepairState> status { get; set; } = new List<MachineRepairState>();

        public List<MachineRepairingOrder> data { get; set; } = new List<MachineRepairingOrder>();
    }

    public class MachineRepairState
    {
        public int status { get; set; }

        public string name { get; set; }

        public int count { get; set; }

        public string icon { get; set; }
    }

    public class MachineRepairingOrder
    {
        public string id { get; set; }

        public int status { get; set; }

        public string location { get; set; }

        public string machinename { get; set; }

        public string faulttype { get; set; }

        public string faultcontent { get; set; }

        public string remark { get; set; }

        public string fault_description { get; set; }

        public string repair_process { get; set; }

        public string reason { get; set; }

        public string sparepartout { get; set; }

        public string createtimeformat { get; set; }

        public string reportname { get; set; }

        public double haslong { get; set; }

        public string status_name { get; set; }
    }

    public class MachineRepairStateList
    {
        public int machineid { get; set; }

        public int status { get; set; }
    }

    public class MaintainPlans
    {
        public int page { get; set; }

        public int pagesize { get; set; }

        public int total { get; set; }

        public List<PlanState> status { get; set; } = new List<PlanState>();

        public List<MaintainPlanOrder> data { get; set; } = new List<MaintainPlanOrder>();
    }

    public class PlanState
    {
        public int status { get; set; }

        public string name { get; set; }

        public int count { get; set; }

        public string icon { get; set; }
    }

    public class MaintainPlanOrder
    {
        public string station { get; set; }

        public string machinetitle { get; set; }

        public int num { get; set; }

        public string instruction_time { get; set; }

        public string name { get; set; }

        public int status { get; set; }
    }

    public class PlanStateList
    {
        public int machineid { get; set; }

        public int status { get; set; }
    }

    public class SkfGtcResult : CncResultBase
    {
       
    }

    public class AllMachineRepairList : SkfGtcResult
    {
        public List<MachineRepairData> data = new List<MachineRepairData>();

        public int page { get; set; }

        public int pagesize { get; set; }

        public int total { get; set; }
    }

    public class MachineRepairData
    {
        public string machinename { get; set; }

        public string failure_mode { get; set; }

        public string failure_time { get; set; }
    }

    public class MachineTypeRepairFaultAndRunState : SkfGtcResult
    {
        public List<string> NAMES = new List<string>();

        public List<MachineTypeRateInRepair> failure { get; set; } = new List<MachineTypeRateInRepair>();

        public List<MachineTypeRunState> utilize { get; set; } = new List<MachineTypeRunState>();
    }

    public class MachineTypeRunState
    {
        public string name { get; set; }

        public int count { get; set; }

        public double rate { get; set; }
    }

    public class MachineTypeRateInRepair
    {
        public string name { get; set; }

        public int count { get; set; }

        public double rate { get; set; }
    }

    public class MachineSensorList : SkfGtcResult
    {
        public List<MachineSensorData> data = new List<MachineSensorData>();

        public int page { get; set; }

        public int pagesize { get; set; }

        public int total { get; set; }
    }

    public class MachineSensorData
    {
        public string sensor { get; set; }

        public string sensor_type { get; set; }

        public int status { get; set; }

        public string last_calibration { get; set; }
    }

    public class MachineMachineCalenderWeeklyList : SkfGtcResult
    {
        public List<MachineMachineCalenderWeekly> data = new List<MachineMachineCalenderWeekly>();
        public int page { get; set; }

        public int pagesize { get; set; }

        public int total { get; set; }
    }

    public class MachineMachineCalenderWeekly
    {
        /// <summary>
        /// 1->Experiment 2->Maintenence 3->Preparation
        /// </summary>
        public List<int> calender_type { get; set; } = new List<int>();

        public string machinename { get; set; }
    }

    public class ResponseSectionsByMachineType
    {
        public string title { get; set; }
        public int count { get; set; }
        public int typeid { get; set; }
    }
}
