﻿using System;
using System.Collections.Generic;

namespace Siger.ApiDashboard.Result
{
    public class WorkshopBoardResult : CncResultBase
    {
        public string msg { get; set; }

        public object data { get; set; }
    }

    public class DevStateCountResult : WorkshopBoardResult
    {
        public DevStateCountResult()
        {
            data = new List<ResponseDevStateCount>();
        }
    }

    public class GroupOeeResult : WorkshopBoardResult
    {
        public GroupOeeResult()
        {
            data = new List<ResponseGroupOee>();
        }
    }

    public class DevStateCountRateResult : WorkshopBoardResult
    {
        public DevStateCountRateResult()
        {
            data = new ResponseDevStateCountRate();
        }
    }

    public class WorkshopHistoryOeeResult : WorkshopBoardResult
    {
        public WorkshopHistoryOeeResult()
        {
            data = new List<ResponseWorkshopHistoryOee>();
        }
    }

    public class ResponseDevStateCount
    {
        public int code { get; set; }

        public string name { get; set; }

        public double runTimeRate { get; set; }

        public double manualTimeRate { get; set; }

        public double modelTimeRate { get; set; }

        public double freeStateRate { get; set; }

        public double shutdownStateRate { get; set; }

        public double faultStateRate { get; set; }

        public double runState { get; set; }

        public double lineChangeState { get; set; }

        public double manualState { get; set; }

        public double freeState { get; set; }

        public double shutdownState { get; set; }

        public double faultState { get; set; }
    }

    public class ResponseGroupOee
    {
        public int code { get; set; }

        public string name { get; set; }

        /// <summary>
        /// 产量
        /// </summary>
        public int output { get; set; }

        public double oee { get; set; }

        /// <summary>
        /// 理论oee
        /// </summary>
        public double theoryOee { get; set; }

        public int machineid { get; set; }
    }

    public class ResponseDevStateCountRate
    {
        public int code { get; set; }

        public string name { get; set; }

        public double runStateRate { get; set; }

        public double lineChangeStateRate { get; set; }

        public double manualStateRate { get; set; }

        public double freeStateRate { get; set; }

        public double shutdownStateRate { get; set; }

        public double faultStateRate { get; set; }

        public double runState { get; set; }

        public double lineChangeState { get; set; }

        public double manualState { get; set; }

        public double freeState { get; set; }

        public double shutdownState { get; set; }

        public double faultState { get; set; }
    }

   public class ResponseWorkshopHistoryOee
    {
        public int code { get; set; }

        public string name { get; set; }

        public double lastmonthoee { get; set; }

        public double monthoee { get; set; }
    }

    public class FaultDataModel
    {
        public string day { get; set; }

        public string name { get; set; }

        /// <summary>
        /// 总数
        /// </summary>
        public int total { get; set; }

        /// <summary>
        /// 最大值
        /// </summary>
        public int max { get; set; }
    }

    public class MachineFaultModel
    {
        public string name { get; set; }

        public decimal total { get; set; }
    }

    public class OeeDataEntity
    {
        public double Run { get; set; }
        public double OEE1 { get; private set; }
        public double OEE2 { get; private set; }
        public double OEE3 { get; private set; }

        public double OEE { get; private set; }

        public int output { get; set; }

        public double theoryOee { get; set; }

        public OeeDataEntity(double oee1 = 0.0, double oee2 = 100.0, double oee3 = 100.0)
        {
            OEE1 = Math.Round(oee1, 2);
            OEE2 = Math.Round(oee2, 2);
            OEE3 = Math.Round(oee3, 2);
            OEE = Math.Round(OEE1 * OEE2 * OEE3 / 10000, 2);
        }
    }
}
