﻿using Siger.Middlelayer.Common.Helpers;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Siger.Middlelayer.TpmRepository.Entities;

namespace Siger.ApiDashboard.Tasks
{
    public class MTTRBFHelper
    {
        /// <summary>
        /// 故障率和使用率
        /// </summary>
        /// <param name="start"></param>
        /// <param name="end"></param>
        /// <param name="list"></param>
        /// <param name="interal"></param>
        /// <param name="type">1: MTTR 2: MTBF</param>
        /// <returns></returns>
        public static double GetMachineMTTRBF(DateTime start, DateTime end, IEnumerable<siger_project_repair> list, int interal, int type = 1)
        {
            if (!list.Any())
            {
                return 0;
            }

            var dtStart = UnixTimeHelper.ConvertDataTimeLong(start);
            var dtEnd = UnixTimeHelper.ConvertDataTimeLong(end);

            var repairs = list.Where(q => q.createtime >= dtStart && q.createtime <= dtEnd);
            var machineIds = repairs.Select(m => m.machineid).Distinct();
            if (!machineIds.Any())
            {
                return 0;
            }

            double totalNormalSeconds = 0;
            int totalNumber = repairs.Count();
            foreach (var machineId in machineIds)
            {
                var machineRepairs = repairs.Where(q => q.machineid == machineId).OrderBy(m => m.createtime)
                    .ToList();
                if (machineRepairs.Any())
                {
                    if (machineRepairs.Count == 1)
                    {
                        totalNormalSeconds = machineRepairs[0].checktime > dtEnd
                            ? dtEnd - machineRepairs[0].createtime
                            : machineRepairs[0].checktime - machineRepairs[0].createtime;
                    }
                    else
                    {
                        totalNormalSeconds += machineRepairs[0].createtime - dtStart;
                        for (int i = 0; i < machineRepairs.Count - 1; i++)
                        {
                            //排除被包含的记录
                            if (machineRepairs[i + 1].checktime > machineRepairs[i].checktime
                                && machineRepairs[i + 1].createtime > machineRepairs[i].checktime)
                            {
                                totalNormalSeconds +=
                                    machineRepairs[i].checktime - machineRepairs[i + 1].createtime;
                            }
                            else
                            {
                                totalNumber--;
                            }
                        }

                        totalNormalSeconds += machineRepairs[machineRepairs.Count - 1].checktime >= dtEnd
                            ? 0
                            : dtEnd - machineRepairs[machineRepairs.Count - 1].checktime;
                    }
                }
            }

            if (totalNumber > 0)
            {
                totalNormalSeconds = totalNormalSeconds / 60;

                if (type == 1)
                {
                    return Math.Round(totalNormalSeconds / totalNumber, 0);
                }

                var total = 24 * 60 * interal * totalNumber;
                if (total > totalNormalSeconds)
                {
                    return Math.Round((total - totalNormalSeconds) / totalNumber, 0);
                }

                return 0;
            }

            return 0;
        }
    }
}
