﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Siger.ApiDashboard.Tasks.Model
{
    public class FjwReportResult
    {
        public FjwReportResult()
        {
            tableData1 = new List<TableColumn>();
            echartData1 = new List<EchartData>();
            tableData2 = new List<TableColumn>();
            echartData2 = new List<EchartDataColor>();
            echartData3 = new List<EchartData3>();
            echartData4 = new List<EchartData>();
            echartData5 = new List<EchartData>();
            tableData5 = new List<TableColumn>();
            echartData6 = new List<EchartData>();
            echartData7 = new List<EchartDataTool>();
            echartData8 = new List<EchartData>();
        }

        public string type { get; set; }
        public string title { get; set; }
        public string productCode { get; set; }
        public string line { get; set; }
        public string datetime { get; set; }

        /// <summary>
        /// 产出列表
        /// </summary>
        public List<TableColumn> tableData1 { get; set; }
        /// <summary>
        /// 良率统计ECHART
        /// </summary>
        public List<EchartData> echartData1 { get; set; }
        /// <summary>
        /// 不良率列表
        /// </summary>
        public List<TableColumn> tableData2 { get; set; }
        /// <summary>
        /// 不良率统计ECHART
        /// </summary>
        public List<EchartDataColor> echartData2 { get; set; }

        /// <summary>
        /// 设备总体运行情况
        /// </summary>
        public string tableData3 { get; set; }

        /// <summary>
        /// 设备总体运行情况饼图
        /// </summary>
        public List<EchartData3> echartData3 { get; set; }

        /// <summary>
        /// 本月综合OEE top5
        /// </summary>
        public string tableData4 { get; set; }

        /// <summary>
        /// 本月综合OEE top5 echart
        /// </summary>
        public List<EchartData> echartData4 { get; set; }

        /// <summary>
        ///5 月度状态对比
        /// </summary>
        public List<EchartData> echartData5 { get; set; }
        /// <summary>
        ///5 月度对比Lable
        /// </summary>
        public string tableText5 { get; set; }
        /// <summary>
        ///5 月度对比列表
        /// </summary>
        public List<TableColumn> tableData5 { get; set; }
        /// <summary>
        /// 6 月度设备报警TOP5 label
        /// </summary>
        public string tableData6 { get; set; }
        /// <summary>
        /// 6 月度设备报警TOP5
        /// </summary>
        public List<EchartData> echartData6 { get; set; }
        /// <summary>
        /// 7 月度刀具报警统计 lable
        /// </summary>
        public string tableData7 { get; set; }

        public List<EchartDataTool> echartData7 { get; set; }

        public List<EchartData> echartData8 { get; set; }
    }
    public class TableColumn
    {
        public string one { get; set; }
        public string two { get; set; }
        public string three { get; set; }
        public string four { get; set; }
        public string five { get; set; }

    }
    public class EchartDataTool
    {
        public EchartDataTool()
        {
            legend = new List<string>();
            xAxis = new List<string>();
            yAxis1 = new List<int>();
            yAxis2 = new List<int>();
            yAxis3 = new List<int>();
            yAxis4 = new List<int>();
            yAxis5 = new List<int>();

        }
        public List<string> legend { get; set; }
        public List<string> xAxis { get; set; }
        public List<int> yAxis1 { get; set; }
        public List<int> yAxis2 { get; set; }
        public List<int> yAxis3 { get; set; }
        public List<int> yAxis4 { get; set; }
        public List<int> yAxis5 { get; set; }

    }
    public class EchartData
    {
        public EchartData()
        {
            xAxis = new List<string>();
            yAxis = new List<string>();
            series = new List<string>();
        }
        public List<string> xAxis { get; set; }
        public List<string> yAxis { get; set; }
        public List<string> series { get; set; }
    }
    /// <summary>
    /// 不良率饼图
    /// </summary>
    public class EchartDataColor : EchartData
    {
        public EchartDataColor()
        {
            color = new List<string>();
        }
        public List<string> color { get; set; }
    }
    public class EchartData3
    {
        public EchartData3()
        {
            color = new List<string>();
            xAxis = new List<string>();
            series = new List<EchartPin>();
        }
        public List<string> color { get; set; }
        public List<string> xAxis { get; set; }
        public List<EchartPin> series { get; set; }
    }
    public class EchartPin
    {
        public string value { get; set; }
        public string name { get; set; }
    }
}
