﻿using Siger.ApiDashboard.Tasks.Model;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Dapper.Utilities.Slice;
using Siger.Middlelayer.Log;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Share.Models;
using Siger.Middlelayer.Utility.Helpers;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Siger.ApiDashboard.Tasks.Reports
{
    public class MouduleMachineSplitanalysis
    {
        public SplitResult GetSplitResult(siger_project_monthreport_config config, siger_project_monthreport_config_template template)
        {
            var result = new SplitResult
            {
                title = template.title
            };
            try
            {
                var translate = new TranslateHelper(ReportDbHelper.Instance.ProjectLanguage(template.project_id) == 1);
                var now = DateTime.Parse(DateTime.Now.ToShortDateString() + " " + config.send_time);
                var machineIds = ReportDbHelper.Instance.GetMachineIds(template);
                var range = ReportDbHelper.Instance.TimeRange(config);
                var timeRange = range.StartTime + " - " + range.EndTime;

                var siceResult = GetMachineSliceData(template, range.StartTime, range.EndTime, machineIds, config.company_id, config.project_id);
                var edata = new Split_EcharData();
                foreach (var r in siceResult)
                {
                    edata.xdata.Add(r.datetime);
                    edata.ydata.shutdown.Add(r.data.num1);
                    edata.ydata.running.Add(r.data.num2);
                    edata.ydata.debug.Add(r.data.num3);
                    edata.ydata.free.Add(r.data.num4);
                    edata.ydata.fult.Add(r.data.num5);
                    result.tableData.Add(new Split_tableData
                    {
                        datetime = r.datetime,
                        hour1 = r.data.hour1,
                        hour2 = r.data.hour2,
                        hour3 = r.data.hour3,
                        hour4 = r.data.hour4,
                        hour5 = r.data.hour5,
                        num1 = r.data.num1,
                        num2 = r.data.num2,
                        num3 = r.data.num3,
                        num4 = r.data.num4,
                        num5 = r.data.num5,
                    });
                }
                result.echartData.Add(edata);

            }
            catch (Exception e)
            {
                Logger.WriteLineError("GetSplitResult failed, error:" + e.StackTrace);
            }
            return result;
        }

        private IEnumerable<MachineCanvasDataInfo> GetMachineSliceData(siger_project_monthreport_config_template template, DateTime beginDate, DateTime endDate, IEnumerable<int> machineIds, int companyId, int projectId)
        {
            var responses = new List<MachineCanvasDataInfo>();
            switch (template.axios)
            {
                case 1:// 按设备
                    {
                        var machineLocation = ReportDbHelper.Instance.GetMachineLocation(machineIds).ToList();
                        foreach (var m in machineIds)
                        {
                            var location = machineLocation.Find(f => f.machine_id == m);
                            var machine = location != null ? location.section_id + location.machine_name : m.ToStr();
                            var setp = SliceManager.GetMachineSlice(beginDate, endDate, new List<int> { m }, companyId, projectId, machine, 2).Result;
                            responses.Add(setp);
                        }
                        break;
                    }
                case 2: //按天
                    {
                        var patchId = 0;
                        var interal = DateTimeHelper.GetInteral(patchId);
                        var dates = DateTimeHelper.GetDateTimes(beginDate, endDate, patchId);
                        foreach (var date in dates)
                        {
                            DateTime start;
                            DateTime end;
                            string dateTime;
                            if (patchId == 0 || patchId == 1)
                            {
                                start = date;
                                end = date.AddDays(interal).AddSeconds(-1) > DateTime.Now
                                    ? DateTime.Now
                                    : date.AddDays(interal).AddSeconds(-1);
                                dateTime = end.ToString(ParameterConstant.DateFormat);
                            }
                            else
                            {
                                start = date.AddDays(1 - date.Day);
                                end = date.AddDays(1 - date.Day).Date.AddMonths(1).AddSeconds(-1) > DateTime.Now
                                    ? DateTime.Now
                                    : date.AddDays(1 - date.Day).Date.AddMonths(1).AddSeconds(-1); //到月底
                                dateTime = end.ToString(ParameterConstant.YearMonthFormat);
                            }

                            var setp = SliceManager.GetMachineSlice(start, end, machineIds, companyId, projectId, dateTime, 2).Result;
                            responses.Add(setp);
                        }

                        break;
                    }
                case 3: //按周
                    {
                        var patchId = 1;
                        var interal = DateTimeHelper.GetInteral(patchId);
                        var dates = DateTimeHelper.GetDateTimes(beginDate, endDate, patchId);
                        foreach (var date in dates)
                        {
                            DateTime start;
                            DateTime end;
                            string dateTime;
                            if (patchId == 0 || patchId == 1)
                            {
                                start = date;
                                end = date.AddDays(interal).AddSeconds(-1) > DateTime.Now
                                    ? DateTime.Now
                                    : date.AddDays(interal).AddSeconds(-1);
                                dateTime = end.ToString(ParameterConstant.DateFormat);
                            }
                            else
                            {
                                start = date.AddDays(1 - date.Day);
                                end = date.AddDays(1 - date.Day).Date.AddMonths(1).AddSeconds(-1) > DateTime.Now
                                    ? DateTime.Now
                                    : date.AddDays(1 - date.Day).Date.AddMonths(1).AddSeconds(-1); //到月底
                                dateTime = end.ToString(ParameterConstant.YearMonthFormat);
                            }

                            var setp = SliceManager.GetMachineSlice(start, end, machineIds, companyId, projectId, dateTime, 2).Result;
                            responses.Add(setp);
                        }
                        break;
                    }
                case 4:// 按自定义分组
                    {
                        var groups = template.param.Split(',').Select(t => t.ToInt()).Distinct();
                        foreach (var g in groups)
                        {
                            var group = ReportDbHelper.Instance.ConfigDbContext.siger_project_dashboard_machine_group.FirstOrDefault(f => f.id == g);
                            //var machines = group.machineid.Split(',').Select(m => m.ToInt());
                            var machines = ReportDbHelper.Instance.GetMachineIdsByGroup(template.project_id, group.machineid);
                            var setp = SliceManager.GetMachineSlice(beginDate, endDate, machines, companyId, projectId, group != null ? group.group : g.ToStr(), 2).Result;
                            responses.Add(setp);
                        }
                        break;
                    }

            }
            return responses;
        }
    }
}
