﻿using Siger.ApiCommon.Utilities;
using Siger.ApiDashboard.Tasks.Model;
using Siger.Middlelayer.Common.AppSettings;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Share.Models;
using System;
using System.IO;

namespace Siger.ApiDashboard.Tasks.Reports
{
    internal abstract class ReporBase
    {
        protected string OriginalContent { get; set; }

        protected string RootDir { get; set; }
        protected ReporBase()
        {
            var fileSetting = Config<FileSettings>.Get();
            var rootDir = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, fileSetting.FileSetting.PhysicalFolder, "Templates");
            if (!Directory.Exists(rootDir))
            {
                throw new Exception("templates path setting is missing.");
            }

            RootDir = rootDir;
        }
        /// <summary>
        /// 2.0 替换HTML
        /// </summary>
        /// <param name="config">表格</param>
        /// <param name="dataStr">图表数据</param>
        /// <param name="range"></param>
        protected abstract void ReplaceHtml(siger_project_monthreport_config config, string dataStr);

        /// <summary>
        ///  2.0 转PDF
        /// </summary>
        /// <param name="config"></param>
        /// <param name="dataStr"></param>
        /// <param name="range"></param>
        /// <returns></returns>
        public abstract ConvertPdfResult GeneratePdf(siger_project_monthreport_config config, string dataStr);
    }
}
