﻿using System;
using System.Collections.Generic;
using System.IO;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.RazorPages;
using Microsoft.EntityFrameworkCore.Internal;
using Siger.ApiCommon.Result;
using Siger.ApiCommon.Utilities;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.AppSettings;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Common.FieldEnum;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.IMSRepository.Entities;
using Siger.Middlelayer.IMSRepository.Repositories.Interface;
using Siger.Middlelayer.IMSRepository.Request;
using Siger.Middlelayer.Utility.Helpers;
using Siger.Middlelayer.Log;
using Siger.Middlelayer.Utility.ImportEntities;
using System.Linq;
using Siger.Middlelayer.IMSRepository.Response;
using Siger.ApiCommon.Filters;

namespace Siger.ApiIMS.Controllers
{
    public class ToolExpectionController : BaseController
    {
        private readonly IUnitOfWork _unitOfWork;
        private readonly IProjectIMSExpectionRepository _toollifeExpectionRepository;

        public ToolExpectionController(IUnitOfWork unitOfWork, IProjectIMSExpectionRepository toollifeExpectionRepository)
        {
            _unitOfWork = unitOfWork;
            _toollifeExpectionRepository = toollifeExpectionRepository;
        }
        /// <summary>
        /// 获取异常换刀记录
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [HttpPost]
        [ProducesDefaultResponseType(typeof(ResponseGetToollifeExpection))]
        public IActionResult GetToolExpection([FromBody]RequestProjectIMSExpection request)
        {
            request.ProjectId = ProjectId;
            var data = _toollifeExpectionRepository.GetPagedList(request);
            return new PagedObjectResult(data.Data, data.Total, request.Page, request.PageSize);
        }
        /// <summary>
        /// 设置异常换刀记录
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult SetToolExpection([FromBody]ResponseGetToollifeExpection request)
        {
            var now = DateTime.Now;
            var uid = UserId;
            var pid = ProjectId;
            if (request.Id == 0)
            {
                var model = Mapper<ResponseGetToollifeExpection, ProjectIMSExpectionEntity>.Map(request);
                model.Editor = uid;
                model.Creator = uid;
                model.Projectid = pid;
                model.CreateTime = now;
                model.EditTime = now;
                model.OrderNumber = _toollifeExpectionRepository.Generator(pid);
                _toollifeExpectionRepository.Insert(model);
            }
            else
            {
                var model = _toollifeExpectionRepository.Get(f => f.Id == request.Id && f.Projectid == pid && f.Status != 0);
                model.Changer = request.Changer;
                model.BlankCode = request.BlankCode;
                model.JigLocation = request.JigLocation;
                model.CoolantTemperature = request.CoolantTemperature;
                model.DefectLocation = request.DefectLocation;
                model.Reason = request.Reason;
                model.Shift = request.Shift;
                model.ProductModel = request.ProductModel;
                model.MachineId = request.MachineId;
                model.CoolantConcentration = request.CoolantConcentration;
                model.ToolNumber = request.ToolNumber;
                model.ToollifeRest = request.ToollifeRest;
                model.StandardSize = request.StandardSize;
                model.OtherQuestion = request.OtherQuestion;
                model.ProductionBatchNumber = request.ProductionBatchNumber;
                model.JigTower = request.JigTower;
                model.CoolantPressure = request.CoolantPressure;
                model.ToolLocation = request.ToolLocation;
                model.DetectivePartsCount = request.DetectivePartsCount;
                model.ActualSize = request.ActualSize;
                model.ToolBatchNumber = request.ToolBatchNumber;
                model.RepairMoldCount = request.RepairMoldCount;
                model.DynamicBalanceResult = request.DynamicBalanceResult;
                model.TechnicalReason = request.TechnicalReason;
                model.MeasuredSize = request.MeasuredSize;
                model.EditTime = now;
                model.Editor = uid;
                model.Datetime = request.Datetime;
                model.ToolStandardLife = request.ToolStandardLife;
                _toollifeExpectionRepository.Update(model);
            }
            if (_unitOfWork.Commit() > 0)
            {
                return new ObjectResult(CommonEnum.Succefull);
            }
            throw new BadRequestException(CommonEnum.Fail);
        }
        /// <summary>
        /// 删除异常换刀记录
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult DelToolExpection(int id)
        {
            var pid = ProjectId;
            var model = _toollifeExpectionRepository.Get(f => f.Id == id && f.Projectid == pid && f.Status != 0);
            if (model == null)
            {
                throw new BadRequestException(CommonEnum.RecordNotFound);
            }
            else
            {
                model.Status = (int)RowState.Invalid;
            }
            _toollifeExpectionRepository.Update(model);
            if (_unitOfWork.Commit() > 0)
            {
                return new ObjectResult(CommonEnum.Succefull);
            }
            throw new BadRequestException(CommonEnum.DeleteFaild);
        }
    }
}