﻿using Microsoft.AspNetCore.Mvc;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository;
using System.Linq;
using Siger.Middlelayer.QmsRepository.Repositories.Interface;
using Siger.Middlelayer.Common.Extensions;
using System;
using Siger.ApiCommon.Result;
using Siger.Middlelayer.QmsRepository.Response;
using System.Collections.Generic;
using Siger.Middlelayer.Common.Helpers;

namespace Siger.ApiQMS.Controllers
{
    public class CheckMessageController : BaseController
    {
        private readonly IUnitOfWork _unitOfWork;
        private readonly ICheckMessageRepository _checkMessageRepository;
        public CheckMessageController(IUnitOfWork unitOfWork, ICheckMessageRepository checkMessageRepository)
        {
            _unitOfWork = unitOfWork;
            _checkMessageRepository = checkMessageRepository;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="status">0未读 1已读 2删除</param>
        /// <param name="page"></param>
        /// <param name="pagesize"></param>
        /// <returns></returns>
        [HttpGet]
        public IActionResult GetMessages(string status, int page, int pagesize)
        {
            var res = _checkMessageRepository.GetPagedList(status, UserId, ProjectId, page, pagesize);
            var data = new List<ReponseCheckMessage>();
            foreach(var item in res.Data)
            {
                var model = Mapper<ReponseCheckMessage, ReponseCheckMessage>.Map(item);
                if (string.IsNullOrEmpty(model.section))
                {
                    model.section = "";
                }
                if(!string.IsNullOrEmpty(model.section) && !string.IsNullOrEmpty(model.parentsection))
                {
                    model.section = $"{model.parentsection}-{model.section}";
                }
                data.Add(model);
            }
            return new PagedObjectResult(data, res.Total, page, pagesize);
        }

        [HttpGet]
        public IActionResult ReadMessage(string id)
        {
            var data = _checkMessageRepository.GetList(t => t.projectid == ProjectId && t.status == (int)RowState.Valid &&
                t.readstate == 0 && t.tomid == UserId);
            if(!string.IsNullOrWhiteSpace(id))
            {
                data = data.Where(t => t.id == id.ToInt());
            }
            var list = data.ToList();

            foreach(var mes in list)
            {
                mes.readstate = 1;
                mes.readtime = DateTime.Now;
                _checkMessageRepository.Update(mes);
            }
            if(_unitOfWork.Commit() > 0)
            {
                return new ObjectResult(CommonEnum.Succefull);
            }
            else
            {
                throw new BadRequestException(CommonEnum.Fail);
            }
        }

        [HttpGet]
        public IActionResult Delete(string id)
        {
            if (string.IsNullOrWhiteSpace(id))
            {
                throw new BadRequestException(RequestEnum.ParameterMiss);
            }
            var ids = id.Split(',', StringSplitOptions.RemoveEmptyEntries);
            var messages = _checkMessageRepository.GetList(t => t.projectid == ProjectId && t.status == (int)RowState.Valid &&
                ids.Select(q=>q.ToInt()).Contains(t.id) && t.tomid == UserId).ToList();
            if(!messages.Any())
            {
                throw new BadRequestException(CommonEnum.NoData);
            }

            foreach(var message in messages)
            {
                message.status = (int)RowState.Invalid;
                _checkMessageRepository.Update(message);
            }
            if (_unitOfWork.Commit() > 0)
            {
                return new ObjectResult(CommonEnum.Succefull);
            }
            else
            {
                throw new BadRequestException(CommonEnum.Fail);
            }
        }

        [HttpGet]
        public IActionResult GetMessageCount()
        {
            var num = _checkMessageRepository.GetUnReadCount(UserId, ProjectId);
            return new ObjectResult(num);
        }
    }
}