﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Siger.ApiCommon.Result;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.QmsRepository.Repositories.Interface;
using Siger.Middlelayer.QmsRepository.Request;
using Siger.Middlelayer.Repository;

namespace Siger.ApiQMS.Controllers
{
    public class ReworkReferenceTypeController : BaseController
    {
        private readonly IUnitOfWork _unitOfWork;
        private readonly IQmsReworkReferenceRepository _qmsReworkReference;
        private readonly IQmsReworkReferenceTypeRepository _referenceTypeRepository;

        public ReworkReferenceTypeController(IUnitOfWork unitOfWork, IQmsReworkReferenceRepository qmsReworkReference,IQmsReworkReferenceTypeRepository referenceTypeRepository)
        {
            _unitOfWork = unitOfWork;
            _qmsReworkReference = qmsReworkReference;
            _referenceTypeRepository = referenceTypeRepository;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="page"></param>
        /// <param name="pageSize"></param>
        /// <returns></returns>
        [HttpGet]
        public IActionResult Getlist(int page,int pageSize)
        {
           var data= _referenceTypeRepository.GetPagedList(page, pageSize, f => f.projectid == ProjectId, "id");
            return new PagedLongTotalObjectResult(data.Data, data.Total, page, pageSize);
        }

        /// <summary>
        /// 报废分类
        /// </summary>
        /// <param name="type"></param>
        /// <returns></returns>
        [HttpGet]
        public IActionResult GetItem(int type)
        {
            var data = _referenceTypeRepository.GetList(f => f.projectid == ProjectId && f.type==type, "id");
            return new ObjectResult(data);
        }
        
        [HttpPost]
        public IActionResult Add([FromBody]RequestReworkReferenceType referenceType)
        {
            if (_referenceTypeRepository.IsExist(f => f.projectid == ProjectId && f.type == referenceType.type && f.name == referenceType.name))
                throw new BadRequestException(CommonEnum.RecordExits);

            _referenceTypeRepository.Insert(new Middlelayer.QmsRepository.Entities.siger_qms_rework_type
            {
                name = referenceType.name,
                type=referenceType.type,
                projectid=ProjectId,
                status=(int)RowState.Valid
            }) ;
            if (_unitOfWork.Commit() > 0)
                return new ObjectResult(CommonEnum.Succefull);
            throw new BadRequestException(CommonEnum.Fail);

        }
        /// <summary>
        /// 修改
        /// </summary>
        /// <param name="reference"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult Modify([FromBody]RequestReworkReferenceType reference)
        {

            var obj = _referenceTypeRepository.Get(f => f.id == reference.id);
            if (obj == null)
                throw new BadRequestException(CommonEnum.RecordNotFound);
            obj.name = reference.name;
            _referenceTypeRepository.Update(obj);
            if (_unitOfWork.Commit() > 0)
                return new ObjectResult(CommonEnum.Succefull);
            throw new BadRequestException(CommonEnum.Fail);
        }
        /// <summary>
        /// 删除
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult Del([FromBody]RequestIds request)
        {
            if (!request.ids.Any())
                throw new BadRequestException(RequestEnum.ParameterMiss);
            foreach (var id in request.ids)
            {
                var obj = _referenceTypeRepository.Get(f => f.id == id);
                if (obj == null)
                    throw new BadRequestException(CommonEnum.RecordNotFound);
                _referenceTypeRepository.Delete(obj);
            }
            if (_unitOfWork.Commit() > 0)
                return new ObjectResult(CommonEnum.Succefull);
            throw new BadRequestException(CommonEnum.Fail);
        }
    }
}
